# Add project specific ProGuard rules here.
# You can control the set of applied configuration files using the
# proguardFiles setting in build.gradle.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# If your project uses WebView with JS, uncomment the following
# and specify the fully qualified class name to the JavaScript interface
# class:
#-keepclassmembers class fqcn.of.javascript.interface.for.webview {
#   public *;
#}

# Uncomment this to preserve the line number information for
# debugging stack traces.
#-keepattributes SourceFile,LineNumberTable

# If you keep the line number information, uncomment this to
# hide the original source file name.
#-renamesourcefileattribute SourceFile

##########################################################################
# Basic directive
-optimizationpasses 5
-dontusemixedcaseclassnames
-dontskipnonpubliclibraryclasses
-dontskipnonpubliclibraryclassmembers
-dontpreverify
-keepattributes EnclosingMethod
-keepattributes Exceptions
-keepattributes *PDFException*
-keepattributes *Annotation*,InnerClasses
-keepattributes Signature
-keepattributes SourceFile,LineNumberTable
-optimizations !code/simplification/cast,!field/*,!class/merging/*
-verbose

##########################################################################
# Android basic

-keep public class * extends android.app.Activity
-keep public class * extends android.app.Appliction
-keep public class * extends android.app.Service
-keep public class * extends android.content.BroadcastReceiver
-keep public class * extends android.content.ContentProvider
-keep public class * extends android.app.backup.BackupAgentHelper
-keep public class * extends android.preference.Preference
-keep public class * extends android.view.View
-keep public class com.android.vending.licensing.ILicensingService
-keep class android.support.** {*;}
-keep class **.R$* {*;}
-keepclasseswithmembernames class * {
    native <methods>;
}
-keepclassmembers class * extends android.app.Activity{
    public void *(android.view.View);
}
-keepclassmembers enum * {
    public static **[] values();
    public static ** valueOf(java.lang.String);
}
-keep public class * extends android.view.View{
    *** get*();
    void set*(***);
    public <init>(android.content.Context);
    public <init>(android.content.Context, android.util.AttributeSet);
    public <init>(android.content.Context, android.util.AttributeSet, int);
}

-keep class * implements android.os.Parcelable {
  public static final android.os.Parcelable$Creator *;
}
-keepclassmembers class * implements java.io.Serializable {
    static final long serialVersionUID;
    private static final java.io.ObjectStreamField[] serialPersistentFields;
    private void writeObject(java.io.ObjectOutputStream);
    private void readObject(java.io.ObjectInputStream);
    java.lang.Object writeReplace();
    java.lang.Object readResolve();
}
-keepclassmembers class * {
    void *(**On*Event);
}
##########################################################################
# androidx
-keep class com.google.android.material.** {*;}
-keep class androidx.** {*;}
-keep public class * extends androidx.**
-keep interface androidx.** {*;}
-dontwarn com.google.android.material.**
-dontnote com.google.android.material.**
-dontwarn androidx.**

##########################################################################
#pdfscan
-keep class com.foxit.pdfscan.PDFScanManager{
     public *;
     protected *;
}
-keep interface com.foxit.pdfscan.ScanPDFDoneCallBack{
     public *;
     protected *;
}

-keep interface com.foxit.pdfscan.IPDFScanManagerListener{
     public *;
     protected *;
}

-keep class com.foxit.pdfscan.UIActionViewBuilder{
     public *;
     protected *;
}

-keep interface com.foxit.pdfscan.IActionViewPresenter{
     public *;
     protected *;
}
-keep class com.foxit.pdfscan.UIContentViewBuilder{
     public *;
     protected *;
}
-keep interface com.foxit.pdfscan.IContentViewPresenter{
     public *;
     protected *;
}
-keep class com.foxit.pdfscan.ToolBarManager{
     public *;
     protected *;
}

-keep interface com.foxit.pdfscan.ObtainDocumentNameCallback{
     public *;
     protected *;
}
-keep interface com.foxit.pdfscan.PDFScanManager$CloseEditPDFCallBack{
     public *;
     protected *;
}
-dontwarn com.foxitsoftware.mobile.**
-keep class com.foxitsoftware.mobile.** {*;}
-keep class com.luratech.** {*;}
-keep class com.foxit.pdfscan.utils.**{ *;}

-keeppackagenames com.foxit.pdfscan.**