/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan;

/**
 * Interface used to if the scaning content changes.
 */
public interface IPDFScanManagerListener {
    /**
     * Success, and no error occurs
     */
    int e_ErrSuccess = 0;
    /**
     * Failed, any unknown error occurs.
     */
    int e_ErrUnknown = 1;

    /**
     * Called when if the scanned file is successfully saved as a pdf document.
     *
     * @param errorCode if the scanned file is successfully saved as a pdf document, the errorCode is {@link #e_ErrSuccess}, otherwise is {@link #e_ErrUnknown}
     * @param path      the document file path.
     */
    void onDocumentAdded(int errorCode, String path);
}
