/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan;

import android.app.Application;

import java.util.ArrayList;
import java.util.List;

public class PDFScanSingleton {

    private boolean isScannerInited = false;
    private boolean isCompressionInited = false;

    private List<IPDFScanManagerListener> mManagerListeners = new ArrayList<>();

    private static final PDFScanSingleton instance = new PDFScanSingleton();

    private PDFScanSingleton() {
    }

    public static PDFScanSingleton getInstance() {
        return instance;
    }

    public void initializeScanner(Application application, long serial1, long serial2) {
        try {
            com.foxitsoftware.mobile.scanning.Library.initialize(
                    application,
                    serial1,
                    serial2);
            isScannerInited = true;
        } catch (RuntimeException e) {
            isScannerInited = false;
        }
    }

    public void initializeCompression(Application application, long serial1, long serial2) {
        try {
            com.foxitsoftware.mobile.compression.Library.initialize(
                    application,
                    serial1,
                    serial2);
            isCompressionInited = true;
        } catch (RuntimeException e) {
            isCompressionInited = false;
        }
    }

    public boolean isInitializeScanner() {
        return isScannerInited;
    }

    public boolean isInitializeCompression() {
        return isCompressionInited;
    }

    public List<IPDFScanManagerListener> getManagerListeners() {
        return mManagerListeners;
    }

    public void registerManagerListener(IPDFScanManagerListener listener) {
        if (mManagerListeners.contains(listener))
            return;
        this.mManagerListeners.add(listener);
    }

    public void unregisterManagerListener(IPDFScanManagerListener listener) {
        if (mManagerListeners.contains(listener)) {
            this.mManagerListeners.remove(listener);
        }
    }

}
