/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan;


import android.content.Context;
import android.util.SparseArray;
import android.widget.ImageView;

import androidx.annotation.IntDef;

import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.impl.BaseBarImpl;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ToolBarManager {


    /**
     * The bottom toolbar of document editing viewController
     */
    public static final int FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR = 1;


    public static final int EDIT_ADD = 1;
    public static final int EDIT_SAVE = 2;
    private SparseArray<BaseBar> mBars = new SparseArray<>();
    private BaseBar mBottomToolbar;

    @IntDef({FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR
    })
    @Retention(RetentionPolicy.SOURCE)
    @interface ScanToolBarManagerType {
    }

    ToolBarManager(Context context) {
        mContext = context;
        mBottomToolbar = new BaseBarImpl(mContext);
        ImageView imageView=new ImageView(mContext);
        imageView.setImageResource(R.drawable.fx_photo2pdf_edit_addpage);
        imageView.setColorFilter(mContext.getResources().getColor(R.color.i3));
        final IBaseItem baseAddItem = new BaseItemImpl(mContext, imageView);
        baseAddItem.setTag(EDIT_ADD);
        baseAddItem.setId(com.foxit.uiextensions.R.id.id_scan_add);
        ImageView imageViewSave=new ImageView(mContext);
        imageViewSave.setImageResource(R.drawable.fx_photo2pdf_save_normal);
        imageViewSave.setColorFilter(mContext.getResources().getColor(R.color.i3));
        final IBaseItem baseSaveItem = new BaseItemImpl(mContext,imageViewSave);
        baseSaveItem.setTag(EDIT_SAVE);
        mBottomToolbar.addView(baseAddItem, BaseBar.TB_Position.Position_CENTER);
        mBottomToolbar.addView(baseSaveItem, BaseBar.TB_Position.Position_CENTER);
        if (AppDisplay.isPad()) {
            mBottomToolbar.setItemInterval(AppResource.getDimensionPixelSize(mContext, com.foxit.uiextensions.R.dimen.ux_bottombar_button_space_pad));
        } else {
            mBottomToolbar.setItemInterval(AppResource.getDimensionPixelSize(mContext, R.dimen.scan_margin_16dp));
        }
        mBars.append(FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR, mBottomToolbar);
    }

    private Context mContext;


    /**
     * Gets the set toolbar object
     *
     * @param toolbarType toolbarType toolbarType The toolbar type that supports the toolbar. Please refer to {@link ScanToolBarManagerType} values and it would be one of these values.
     * @return Returns the toolbar set by the user
     */
    public BaseBar getToolBar(@ScanToolBarManagerType int toolbarType) {
        return mBars.get(toolbarType);
    }

    /**
     * Add Tool Bar
     *
     * @param toolbarType toolbarType The toolbar type that supports the toolbar. Please refer to {@link ScanToolBarManagerType} values and it would be one of these values.
     * @param baseBar     User set toolbar
     */
    public void addToolBar(@ScanToolBarManagerType int toolbarType, BaseBar baseBar) {
        mBars.append(toolbarType, baseBar);
        if (mBars.get(toolbarType) != null) {
            if (AppDisplay.isPad()) {
                mBars.get(toolbarType).setItemInterval(AppResource.getDimensionPixelSize(mContext, com.foxit.uiextensions.R.dimen.ux_bottombar_button_space_pad));
            } else {
                mBars.get(toolbarType).setItemInterval(AppResource.getDimensionPixelSize(mContext, R.dimen.scan_margin_16dp));
            }
        }
    }

    /**
     * remove Tool Bar
     *
     * @param toolbarType toolbarType The toolbar type that supports the toolbar. Please refer to {@link ScanToolBarManagerType} values and it would be one of these values.
     */
    public void remove(@ScanToolBarManagerType int toolbarType) {
        mBars.remove(toolbarType);
    }

}
