/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;

import androidx.fragment.app.Fragment;

import com.foxit.pdfscan.fragment.EditPDFFragment;

public class EditPDFActivity extends SingleFragmentActivity {
    private EditPDFFragment editPDFFragment;
    public static final int RESULT_CODE = 1001;

    @Override
    protected Fragment createFragment() {
        if (editPDFFragment == null) {
            editPDFFragment = new EditPDFFragment();
        }

        return editPDFFragment;
    }

    @Override
    public void onBackPressed() {
        if (editPDFFragment != null) {
            editPDFFragment.stopEditMode();
        }
    }

    public void setFragment(EditPDFFragment editPDFFragment) {
        this.editPDFFragment = editPDFFragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // Hide the status bar and other OS-level chrome
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (editPDFFragment != null && !editPDFFragment.isHidden() && !editPDFFragment.isDetached())
            editPDFFragment.onActivityResult(requestCode, resultCode, data);
    }
}
