/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.browser;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.foxit.pdfscan.R;

public class BrowserSectionHeaderView extends FrameLayout {
    private TextView mHeader;

    public BrowserSectionHeaderView(Context context) {
        super(context);
        initView();
    }

    public BrowserSectionHeaderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        initView();
    }

    private void initView() {
        View view = inflate(getContext(), R.layout.fx_photo2pdf_fragment_browser_list_header, null);
        addView(view);
        mHeader = (TextView) findViewById(R.id.browser_header_title);
    }

    public void setTitle(String title) {
        mHeader.setText(title);
    }
}
