/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.browser;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.foxit.pdfscan.views.BrowserItemView;
import com.luratech.android.appframework.Document;

import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

public abstract class ViewPagerAdapter extends PagerAdapter {
    private Document document;

    public ViewPagerAdapter(Document document) {
        this.document = document;
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public int getCount() {
        return 2;
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        final ViewPager viewPager = (ViewPager) container;
        BrowserItemView browserItemView = new BrowserItemView(container.getContext());
        browserItemView.setItem(document);
        // Layout fix for ViewPager embedded in a ListView
        browserItemView.measure(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        viewPager.getLayoutParams().height = browserItemView.getMeasuredHeight();
        container.addView(browserItemView);
        return browserItemView;
    }

    @Override
    public void destroyItem(ViewGroup viewPager, int position, Object object) {
        viewPager.removeViewAt(position);
    }

    @Override
    public int getItemPosition(Object object) {
        return POSITION_NONE;
    }

    protected abstract void delete();

    protected abstract void rename();

}
