/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.ResourceUtils;

public abstract class AlreadyExistsDialog extends AlertDialog.Builder implements OnClickListener {

    public AlreadyExistsDialog(Context context, String documentName) {
        super(context);
        String positive = ResourceUtils.getString(context, R.string.scan_string_ok);
        setPositiveButton(positive, this);
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (which == DialogInterface.BUTTON_POSITIVE) {
            positive();
        }
    }

    protected abstract void positive();
}
