/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;

public abstract class SaveEditedImageDialog extends AlertDialog.Builder implements OnClickListener {

    public SaveEditedImageDialog(Context context) {
        super(context);

        setTitle("You have unsaved changes");
        setMessage("Do you want to save changes?");
        String positive = "Save";
        setPositiveButton(positive, this);
        String negative = "Cancel";
        setNegativeButton(negative, this);
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (which == DialogInterface.BUTTON_POSITIVE) {
            positive();
        } else if (which == DialogInterface.BUTTON_NEGATIVE) {
            negative();
        }
    }

    protected abstract void positive();

    protected abstract void negative();
}
