/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.fragment;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Bundle;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.pdfscan.utils.SessionIntentUtils;
import com.foxit.pdfscan.views.CropView;
import com.foxit.uiextensions.utils.AppResource;
import com.foxitsoftware.mobile.scanning.DocumentSession;
import com.foxitsoftware.mobile.scanning.DocumentSessionManagerFactory;
import com.luratech.android.appframework.BitmapWithMetadata;

import java.util.ArrayList;
import java.util.List;

public class CropViewFragment extends Fragment implements View.OnClickListener {
    public static final String RESULT_DETECTION = "RESULT_DETECTION";
    private CropView cropView;
    private TextView ok, cancel;
    public static TextView mReset;
    private DocumentSession session;
    public static PointF[] croppedPoints = new PointF[0];
    private BitmapWithMetadata newBitmap;

    boolean modified;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fx_photo2pdf_fragment_cropview, parent, false);
        cropView = (CropView) view.findViewById(R.id.cropView);

        view.setBackgroundColor(AppResource.getColor(getContext(), R.color.scan_color_2E2E2E));
        view.findViewById(R.id.photo2pdf_cropview_bottom_bar).setBackgroundColor(AppResource.getColor(getContext(), R.color.scan_color_black));

        Intent intent = getActivity().getIntent();
        try {
            session = SessionIntentUtils.getSession(intent);
        } catch (Exception e) {
            session =  DocumentSessionManagerFactory.getInstance().createSession();
            e.printStackTrace();
        }
        int page = intent.getIntExtra(EditImageFragment.EXTRA_PAGE, 0);
        int width = intent.getIntExtra("width", 0);
        int height = intent.getIntExtra("height", 0);

        List<PointF> listToPass = intent.getExtras().getParcelableArrayList(
                CropViewFragment.RESULT_DETECTION);
        listToPass = listToPass.subList(0, Math.min(listToPass.size(), 4));
        croppedPoints = listToPass.toArray(new PointF[listToPass.size()]);

        BitmapWithMetadata bitmap = session.getImageForPage(page);
        Bitmap orlBitmap = bitmap.getBitmap();
        Matrix matrix = new Matrix();
        int origWidth = bitmap.getWidth();
        int origHeight = bitmap.getHeight();
        //float  widthZoom  =  (float)(Math.round(((float) (width - 20)* 10/(float)bitmap.getWidth())*10))/100;
        //float  heightZoom  =  (float)(Math.round(((float) (height- 20)* 10/(float)bitmap.getHeight())*10))/100;
        float margin = DisplayUtils.getInstance(getActivity().getApplicationContext()).dp2px(16);
        float widthZoom = (float) (width - margin) / (float) bitmap.getWidth();
        float heightZoom = (float) (height - margin) / (float) bitmap.getHeight();
        float zoom = widthZoom >= heightZoom ? heightZoom : widthZoom;
        int calcWidth = (int) (origWidth * zoom);
        matrix.postScale(zoom, zoom);
        Bitmap resizeBmp = Bitmap.createBitmap(orlBitmap, 0, 0, orlBitmap.getWidth(), orlBitmap.getHeight(), matrix, true);
        newBitmap = new BitmapWithMetadata();
        newBitmap.setBitmap(resizeBmp);
        cropView.setBitmap(newBitmap);
        cropView.setPoints(croppedPoints);
        cropView.setOnDragListener(new View.OnDragListener() {
            @Override
            public boolean onDrag(View v, DragEvent event) {
                modified = true;
                return true;
            }
        });


        ok = view.findViewById(R.id.photo2pdf_fragment_editimage_corp_save);
        ok.setOnClickListener(this);
        cancel = view.findViewById(R.id.photo2pdf_fragment_editimage_corp_cancel);
        cancel.setOnClickListener(this);
        mReset = (TextView) view.findViewById(R.id.photo2pdf_cropview_reset);
        mReset.setOnClickListener(this);

        updateButtonState();
        return view;
    }

    private void updateButtonState() {

    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menuitem_apply) {// finish activity with apply
            resultSave();
            return true;
        }
        return false;
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.photo2pdf_fragment_editimage_corp_save) {
            resultSave();
        } else if (id == R.id.photo2pdf_fragment_editimage_corp_cancel) {
            getActivity().finish();
        } else if (id == R.id.photo2pdf_cropview_reset) {
//            int color = mReset.getCurrentTextColor();
//            if (color == getContext().getResources().getColor(R.color.scan_color_white)) // Color.parseColor("#FF179CD8")
//                return;
            mReset.setTextColor(getContext().getResources().getColor(R.color.scan_color_white));
            cropView.setBitmap(newBitmap);
            //cropView.setPoints(croppedPoints);
            cropView.setPoints(CropView.mFullPoints4);
        }
    }

    private void resultSave() {
        Intent intent = new Intent();
        croppedPoints = cropView.getCroppedPoints();
        ArrayList<PointF> listToPass = new ArrayList<PointF>();
        for (int i = 0; i < croppedPoints.length; i++) {
            PointF point = croppedPoints[i];
            point.x = Math.min(1f, Math.max(0f, point.x));
            point.y = Math.min(1f, Math.max(0f, point.y));
            listToPass.add(point);
        }
        intent.putExtra(RESULT_DETECTION, listToPass);
        getActivity().setResult(Activity.RESULT_OK, intent);
        getActivity().finish();
    }


}
