/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.foxit.pdfscan.ActRequestCode;
import com.foxit.pdfscan.PDFScanManager;
import com.foxit.pdfscan.R;
import com.foxit.pdfscan.ScannerSession;
import com.foxit.pdfscan.activity.CropActivity;
import com.foxit.pdfscan.activity.EditImageActivity;
import com.foxit.pdfscan.activity.ScannerCameraActivity;
import com.foxit.pdfscan.dialog.SaveEditedImageDialog;
import com.foxit.pdfscan.statecolor.StateColorAdapter;
import com.foxit.pdfscan.statecolor.StateColorBean;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.pdfscan.utils.ResourceUtils;
import com.foxit.pdfscan.utils.SessionIntentUtils;
import com.foxit.pdfscan.utils.ThreadManager;
import com.foxit.pdfscan.viewpdf.DocumentViewerPagerAdapter;
import com.foxit.pdfscan.views.ProgressBarView;
import com.foxit.pdfscan.views.ToastSeekBar;
import com.foxit.pdfscan.views.ZoomingAndPanningViewPager;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxitsoftware.mobile.scanning.DocumentEditingSession;
import com.foxitsoftware.mobile.scanning.DocumentSessionManagerFactory;
import com.luratech.android.appframework.BitmapWithMetadata;
import com.luratech.android.appframework.DetectionResult;
import com.luratech.android.appframework.ImageProcessor;
import com.luratech.android.appframework.ImageProcessorListener;

import java.util.ArrayList;
import java.util.List;

public class EditImageFragment extends Fragment implements  EditImageActivity.BackPressedCallBack,
        ImageProcessorListener, ViewPager.OnPageChangeListener, View.OnClickListener {
    private static final String TAG = EditImageFragment.class.getSimpleName();

    /**
     * Initial PDF page number to edit.
     */
    public static final String EXTRA_PAGE = "page";

    /**
     * Current document session containing the PDF to be edited.
     */
    private DocumentEditingSession editingSession;

    /**
     * Image processor to change the image.
     */
    private ImageProcessor mImageProcessor;

    /**
     * Zooming and panning ViewPager to display and choose the PDF page and edit
     * the corresponding image.
     */
    private ZoomingAndPanningViewPager mImagePager;

    /**
     * Progress bar view to be temporarily shown, while image processing is
     * executed.
     */
    private ProgressBarView mProgressBarView;

    /**
     * Counting the number of nested background image processing steps.
     */
    protected int inProgressCounter;
    /**
     * Trigger for the final image processing, short before the activity
     * finishes.
     */
    private boolean isResult, isPageResult, outgoingChange;
    private int currentPage;
    private int mPageIndex;
    public static final int RESULT_SCAN_IMAGE = 1010;
    public static final String RESULT_SCAN_UPDATE = "isUpdate";
    private PointF[] croppedPoints = new PointF[0];

    private DocumentViewerPagerAdapter mImagePagerAdapter;


    private ImageView mCropButton, mColorButton, mRotateButton, mRemakeButton;
    private TextView mCancelButton, mSaveButton, mColorDoneButton;


    private RelativeLayout mEditImageTwoToolbar;
    private LinearLayout mEditImageOneToolbar;
    private RecyclerView mEditImageRecyclerViewColorState;
    private ImageView mColorImageView, mBrightnessImageView, mContrastImageView;

    private ToastSeekBar mEditImageBrightnessSeekBar;
    private ToastSeekBar mEditImageContrastSeekBar;
    private Context mContext;

    private static String ROTATE = "rotate";
    private static String CORP = "corp";
    private static String BRIGHTNESS = "brightness";
    private static String CONTRAST = "contrast";
    private static String COLORSPACE = "colorspace";
    private static String CAMERA = "camera";
    public static String fromWhere = "";

    private String state = "";

    private List<StateColorBean> mStateColorBeanList = new ArrayList<>();
    private StateColorAdapter mStateColorAdapter = null;

    private PDFScanManager mPDFScanManager;

    private int mBrightness = 0;
    private int mContrast = 0;

    private LinearLayout mLlStateColorBg;
    private int mNightMode = -1;

    private BitmapWithMetadata mOri_Bitmap;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(false);
        mPDFScanManager = PDFScanManager.instance();
        mNightMode = getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mNightMode != (newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK)) {
            mNightMode = newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK;
            ThemeUtil.setTintList(mColorImageView, ThemeUtil.getSelectedIconColor(getContext()));
            ThemeUtil.setTintList(mBrightnessImageView, ThemeUtil.getSelectedIconColor(getContext()));
            ThemeUtil.setTintList(mContrastImageView, ThemeUtil.getSelectedIconColor(getContext()));
            mEditImageBrightnessSeekBar.setProgressColor(ThemeConfig.getInstance(getContext()).getPrimaryColor());
            mEditImageContrastSeekBar.setProgressColor(ThemeConfig.getInstance(getContext()).getPrimaryColor());
        }

    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        mContext = getActivity().getApplicationContext();
        Intent intent = getActivity().getIntent();
        try {
            editingSession = (DocumentEditingSession) SessionIntentUtils.getSession(intent);
        } catch (Exception e) {
            editingSession = DocumentSessionManagerFactory.getInstance().createSession();
            e.printStackTrace();
        }
        mPageIndex = intent.getIntExtra(EXTRA_PAGE, 0);
        View view = inflater.inflate(R.layout.fx_photo2pdf_fragment_editimage, container, false);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            view.setForceDarkAllowed(false);
        }
        view.setBackgroundColor(AppResource.getColor(mContext, R.color.scan_color_2E2E2E));
        mImagePager = (ZoomingAndPanningViewPager) view.findViewById(R.id.scanner_edit_image_pager);
        mImagePagerAdapter = new DocumentViewerPagerAdapter(editingSession, getFragmentManager());
        mImagePager.setAdapter(mImagePagerAdapter);
        mImagePager.addOnPageChangeListener(this);
        mImagePager.setCurrentItem(mPageIndex);
        //mImagePager.setSwipeEnabled(true);
        mImagePager.setSwipeEnabled(false);

        mOri_Bitmap = prepareNextPage(mPageIndex);
        mRotateButton = (ImageView) view.findViewById(R.id.scanner_edit_image_rotate_button);
        mRotateButton.setOnClickListener(this);
        mRemakeButton = view.findViewById(R.id.scanner_edit_image_remake_button);
        mRemakeButton.setOnClickListener(this);
        mCropButton = (ImageView) view.findViewById(R.id.scanner_edit_image_crop_button);
        mCropButton.setOnClickListener(this);
        mColorButton = (ImageView) view.findViewById(R.id.scanner_edit_image_color_button);
        mColorButton.setImageResource(R.drawable.fx_photo2pdf_editimage_brightness);
        mColorButton.setOnClickListener(this);

        if (DisplayUtils.getInstance(mContext).isPad()) {
            LinearLayout.LayoutParams rl = (LinearLayout.LayoutParams) mRemakeButton.getLayoutParams();
            rl.rightMargin = ResourceUtils.getDimensionPixelSize(mContext, R.dimen.scan_bottombar_button_space_pad);

            rl = (LinearLayout.LayoutParams) mRotateButton.getLayoutParams();
            rl.rightMargin = ResourceUtils.getDimensionPixelSize(mContext, R.dimen.scan_bottombar_button_space_pad);

            rl = (LinearLayout.LayoutParams) mCropButton.getLayoutParams();
            rl.rightMargin = ResourceUtils.getDimensionPixelSize(mContext, R.dimen.scan_bottombar_button_space_pad);
        }

        mCancelButton = (TextView) view.findViewById(R.id.scanner_edit_image_cancel_button);
        mCancelButton.setOnClickListener(this);

        mSaveButton = (TextView) view.findViewById(R.id.scanner_edit_image_save_button);
        mSaveButton.setOnClickListener(this);

        mProgressBarView = (ProgressBarView) view.findViewById(R.id.scanner_edit_image_progress_bar);


        mEditImageOneToolbar = view.findViewById(R.id.scanner_edit_image_one_toolbar);
        mEditImageOneToolbar.setBackgroundColor(AppResource.getColor(mContext, com.foxit.uiextensions.R.color.ux_color_black));

        mEditImageTwoToolbar = view.findViewById(R.id.scanner_edit_image_two_toolbar);
        mEditImageTwoToolbar.setBackgroundColor(AppResource.getColor(mContext, com.foxit.uiextensions.R.color.ux_color_black));
//        mEditImageTwoToolbar.getBackground().setAlpha((int) (255 * 0.4));

        mLlStateColorBg = view.findViewById(R.id.scanner_ll_color_state_bg);
        mEditImageRecyclerViewColorState = view.findViewById(R.id.scanner_edit_image_recycler_view_color_state);
        mLlStateColorBg.getBackground().setAlpha((int) (255 * 0.4));
        addImageColors();

        mColorImageView = view.findViewById(R.id.scanner_edit_image_color_image_view);
        mBrightnessImageView = view.findViewById(R.id.scanner_edit_image_brightness_image_view);
        mContrastImageView = view.findViewById(R.id.scanner_edit_image_contrast_image_view);
        mColorImageView.setOnClickListener(this);
        mBrightnessImageView.setOnClickListener(this);
        mContrastImageView.setOnClickListener(this);

        ThemeUtil.setTintList(mColorImageView, ThemeUtil.getSelectedIconColor(getContext()));
        ThemeUtil.setTintList(mBrightnessImageView, ThemeUtil.getSelectedIconColor(getContext()));
        ThemeUtil.setTintList(mContrastImageView, ThemeUtil.getSelectedIconColor(getContext()));
        mColorImageView.setSelected(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            mRotateButton.setForceDarkAllowed(false);
            mRemakeButton.setForceDarkAllowed(false);
            mCropButton.setForceDarkAllowed(false);
            mColorButton.setForceDarkAllowed(false);
            mColorImageView.setForceDarkAllowed(false);
            mBrightnessImageView.setForceDarkAllowed(false);
            mContrastImageView.setForceDarkAllowed(false);
        }

        mEditImageBrightnessSeekBar = view.findViewById(R.id.scanner_edit_image_brightness_seek_bar);
        mEditImageBrightnessSeekBar.setProgressColor(ThemeConfig.getInstance(getContext()).getPrimaryColor());
        mEditImageContrastSeekBar = view.findViewById(R.id.scanner_edit_image_contrast_seek_bar);
        mEditImageContrastSeekBar.setProgressColor(ThemeConfig.getInstance(getContext()).getPrimaryColor());
        View v = LayoutInflater.from(getContext()).inflate(R.layout.fx_photo2pdf_fragment_editimage_seek_bar_toast, null);
        mEditImageBrightnessSeekBar.setToastView(v);
        mEditImageBrightnessSeekBar.setBrightLevel(true);
        mEditImageBrightnessSeekBar.setOnSeekBarProgressListener(new ToastSeekBar.OnSeekBarProgressListener() {
            @Override
            public void onProgress(int progress) {
                seekBarChanged(mEditImageBrightnessSeekBar, progress, "brightness");
            }
        });
        mEditImageContrastSeekBar.setToastView(v);
        mEditImageContrastSeekBar.setBrightLevel(false);
        mEditImageContrastSeekBar.setOnSeekBarProgressListener(new ToastSeekBar.OnSeekBarProgressListener() {
            @Override
            public void onProgress(int progress) {
                seekBarChanged(mEditImageBrightnessSeekBar, progress, "contrast");
            }
        });
        ((EditImageActivity) getActivity()).setOnBackPressedListener(this);

        updateButtonState();
        return view;
    }

    private boolean _changed() {
        return state.equals(CORP) || state.equals(ROTATE) || state.equals(BRIGHTNESS)
                || state.equals(CONTRAST) || state.equals(COLORSPACE) || state.equals(CAMERA);
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.scanner_edit_image_cancel_button) {
            if (getActivity() != null) {
                if (reset()) return;
//                if (!fromWhere.equals("") && fromWhere.equals("ScannerCameraActivity")) {
//                    Intent intent = new Intent(getActivity(), ScannerCameraActivity.class);
//                    editingSession.removePage(mPageIndex);
//                    SessionIntentUtils.saveSessionId(intent, editingSession);
//                    startActivity(intent);
//                    fromWhere = "";
//                }

                // reset image
                editingSession.replacePage(currentPage, mOri_Bitmap);
                getActivity().finish();
            }
            if (mImageProcessor != null)
                mImageProcessor.close();
        } else if (id == R.id.scanner_edit_image_save_button) {
            if (mEditImageTwoToolbar.getVisibility() == View.VISIBLE) {
                mEditImageTwoToolbar.setVisibility(View.GONE);
                mEditImageOneToolbar.setVisibility(View.VISIBLE);
                mEditImageRecyclerViewColorState.setVisibility(View.GONE);
                mLlStateColorBg.setVisibility(View.GONE);
                mEditImageBrightnessSeekBar.setVisibility(View.GONE);
                mEditImageContrastSeekBar.setVisibility(View.GONE);
                mContrast = mEditImageContrastSeekBar.getProgress();
                mBrightness = mEditImageBrightnessSeekBar.getProgress();
                mSaveButton.setText(R.string.scan_string_save);
                updateButtonState();
                return;
            }


            isResult = true;
            mImageProcessor.computeResult();

        } else if (id == R.id.scanner_edit_image_remake_button) {
            Intent intent = new Intent(getActivity(), ScannerCameraActivity.class);
            SessionIntentUtils.saveSessionId(intent, editingSession);
            intent.putExtra(ScannerSession.EXTRA_REMAKE_INDEX, mPageIndex);
            startActivityForResult(intent, ActRequestCode.REQ_SCAN_CAMERA_REMAKE);
        } else if (id == R.id.scanner_edit_image_rotate_button) {
            mColorButton.setImageResource(R.drawable.fx_photo2pdf_editimage_brightness);
            mImagePager.addOnPageChangeListener(this);
            mImagePager.setCurrentItem(mPageIndex);
            mImageProcessor.rotate(ImageProcessor.RotationDirection.CCW);
            mImageProcessor.computePreview();
            outgoingChange = true;
            state = ROTATE;
            updateButtonState();
        } else if (id == R.id.scanner_edit_image_crop_button) {
            mColorButton.setImageResource(R.drawable.fx_photo2pdf_editimage_brightness);
            Intent intent = new Intent(getActivity(), CropActivity.class);
            SessionIntentUtils.saveSessionId(intent, editingSession);
            intent.putExtra(EditImageFragment.EXTRA_PAGE, currentPage);
            intent.putExtra("width", mImagePager.getWidth());
            intent.putExtra("height", mImagePager.getHeight());
            ArrayList<PointF> listToPass = new ArrayList<PointF>();
            for (int i = 0; i < croppedPoints.length; i++) {
                PointF point = croppedPoints[i];
                point.x = Math.min(1f, Math.max(0f, point.x));
                point.y = Math.min(1f, Math.max(0f, point.y));
                listToPass.add(point);
            }
            intent.putExtra(CropViewFragment.RESULT_DETECTION, listToPass);
            mImagePager.addOnPageChangeListener(this);
            mImagePager.setCurrentItem(mPageIndex);
            startActivityForResult(intent, ActRequestCode.REQ_SCAN_DETECTION_RESULT);
        } else if (id == R.id.scanner_edit_image_color_button) {
            mImagePager.addOnPageChangeListener(this);
            mImagePager.setCurrentItem(mPageIndex);

//            if (!colorList) {
//                mEditImageColorBottomView.setVisibility(View.VISIBLE);
//                colorList = true;
//            } else {
//                mEditImageColorBottomView.setVisibility(View.INVISIBLE);
//                mColorButton.setImageResource(R.drawable.fx_photo2pdf_editimage_brightness);
//                colorList = false;
//            }
            mEditImageOneToolbar.setVisibility(View.GONE);
            mSaveButton.setText(R.string.scan_string_done);
            mSaveButton.setEnabled(true);
            mSaveButton.setAlpha(1.0f);
            mCancelButton.setText(R.string.scan_string_cancel);
            mEditImageTwoToolbar.setVisibility(View.VISIBLE);
            mColorImageView.setSelected(false);
            mBrightnessImageView.setSelected(false);
            mContrastImageView.setSelected(false);
        } else if (id == R.id.scanner_edit_image_color_image_view) {
            mColorImageView.setSelected(true);
            mBrightnessImageView.setSelected(false);
            mContrastImageView.setSelected(false);
            mEditImageRecyclerViewColorState.setVisibility(View.VISIBLE);
            mLlStateColorBg.setVisibility(View.VISIBLE);
            mEditImageBrightnessSeekBar.setVisibility(View.GONE);
            mEditImageContrastSeekBar.setVisibility(View.GONE);
        } else if (id == R.id.scanner_edit_image_brightness_image_view) {
            mColorImageView.setSelected(false);
            mBrightnessImageView.setSelected(true);
            mContrastImageView.setSelected(false);
            mEditImageRecyclerViewColorState.setVisibility(View.GONE);
            mLlStateColorBg.setVisibility(View.GONE);
            mEditImageBrightnessSeekBar.setVisibility(View.VISIBLE);
            mEditImageContrastSeekBar.setVisibility(View.GONE);
        } else if (id == R.id.scanner_edit_image_contrast_image_view) {
            mColorImageView.setSelected(false);
            mBrightnessImageView.setSelected(false);
            mContrastImageView.setSelected(true);
            mEditImageRecyclerViewColorState.setVisibility(View.GONE);
            mLlStateColorBg.setVisibility(View.GONE);
            mEditImageBrightnessSeekBar.setVisibility(View.GONE);
            mEditImageContrastSeekBar.setVisibility(View.VISIBLE);
        }
    }


    @Override
    public void onPageScrollStateChanged(int arg0) {
    }

    @Override
    public void onPageScrolled(int arg0, float arg1, int arg2) {
    }

    /**
     * Each time a PDF page changes, create a new image processor.
     */
    @Override
    public void onPageSelected(final int page) {
        if (outgoingChange) {
            if (currentPage != page) {
                // Overwrite warning
                new SaveEditedImageDialog(getActivity()) {
                    @Override
                    protected void positive() {
                        // compute resulting image (save and go to next page)
                        isPageResult = true;
                        mImageProcessor.computeResult();
                    }

                    @Override
                    protected void negative() {
                        mImagePager.setCurrentItem(currentPage);
                    }
                }.show();
            }
        } else {
            prepareNextPage(page);
        }
    }

    @Override
    public void onStartedProcessingImage(ImageProcessor processor) {
        if (processor == mImageProcessor) {
            ThreadManager.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (inProgressCounter++ == 0) {
                        mProgressBarView.start(getActivity(), false);
                    }
                }
            });
        }
    }

    @Override
    public void onDoneComputingImage(final ImageProcessor processor,
                                     final BitmapWithMetadata bitmap) {
        if (processor == mImageProcessor) {
            //mBitmap = bitmap;
            ThreadManager.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (--inProgressCounter == 0) {
                        mProgressBarView.end();
                    }
                    if (isPageResult) {
                        // Changes of a PDF page should be saved
                        int page = mImagePager.getCurrentItem();
                        editingSession.replacePage(currentPage, bitmap);

                        // then go to the next page
                        //editImageActionsView.resetEditingMode();
                        prepareNextPage(page);
                    } else if (isResult) {
                        int page = mImagePager.getCurrentItem();
                        editingSession.replacePage(page, bitmap);
                        if (getActivity() != null) {
//                            if (!fromWhere.equals("") && fromWhere.equals("ScannerCameraActivity")) {
//                                Intent editIntent = new Intent(getActivity(), EditPDFActivity.class);
//                                SessionIntentUtils.saveSessionId(editIntent, editingSession);
//                                startActivity(editIntent);
//                                fromWhere = "";
//                            }
                            Intent intent = getActivity().getIntent();
                            intent.putExtra(RESULT_SCAN_UPDATE,true);
                            intent.putExtra(EditImageFragment.EXTRA_PAGE, currentPage);
                            getActivity().setResult(RESULT_SCAN_IMAGE, intent);
                            getActivity().finish();
                        }
                        processor.close();
                    } else {
                        // image processing done, update view
                        updateView(bitmap, mImagePager.getCurrentItem());
                    }
                }
            });
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == Activity.RESULT_OK) {
            if (requestCode == ActRequestCode.REQ_SCAN_DETECTION_RESULT) {
                state = CORP;
                List<PointF> listToPass = data.getExtras().getParcelableArrayList(CropViewFragment.RESULT_DETECTION);
                listToPass = listToPass.subList(0, 4);
                croppedPoints = listToPass.toArray(new PointF[listToPass.size()]);
                DetectionResult detectionResult = new DetectionResult(1, 1);
                detectionResult.setPoints(croppedPoints);
                mImageProcessor.setDetectionResult(detectionResult);
                mImageProcessor.computePreview();
                updateButtonState();
            } else if (requestCode == ActRequestCode.REQ_SCAN_CAMERA_REMAKE) {
                state = CAMERA;
                BitmapWithMetadata bitmap = prepareNextPage(mPageIndex);
                updateView(bitmap, mPageIndex);
                updateButtonState();
            }
        }
    }

    private void updateButtonState() {
        if (mEditImageTwoToolbar.getVisibility() == View.GONE) {
            if (_changed()) {
                mCancelButton.setText(R.string.scan_string_cancel);
                mSaveButton.setEnabled(true);
                mSaveButton.setAlpha(1.0f);
            } else {
                mCancelButton.setText(R.string.scan_string_back);
                mSaveButton.setEnabled(false);
                mSaveButton.setAlpha(0.5f);
            }
        } else {
            mCancelButton.setText(R.string.scan_string_cancel);
        }
    }

    /**
     * Prepare editing the next page.
     *
     * @param page current page number
     * @return bitmap of the page
     */
    private BitmapWithMetadata prepareNextPage(int page) {
        setTitle(page);
        currentPage = page;
        outgoingChange = false;
        isPageResult = false;
        isResult = false;

        BitmapWithMetadata bitmap = editingSession.getImageForPage(page);
        createImageProcessor(bitmap);
        return bitmap;
    }

    private void setTitle(final int page) {
//        Resources resources = getActivity().getResources();
        //		getActivity().setTitle(
        //				resources.getString(R.string.editimage_title, (page + 1)));
        getActivity().setTitle("1");
    }

    /**
     * Create image processor for the specified bitmap.
     *
     * @param imageForPage bitmap to apply changes to
     */
    private void createImageProcessor(BitmapWithMetadata imageForPage) {
        //this.imageForPage = imageForPage;
        if (mImageProcessor != null)
            mImageProcessor.close();

        mImageProcessor = new ImageProcessor();
        mImageProcessor.setComputeLowResPreview(true);
        mImageProcessor.setInputImage(imageForPage);
        DetectionResult detectionResult = new DetectionResult(1, 1);
        detectionResult.setPoints(croppedPoints);
        mImageProcessor.setDetectionResult(detectionResult);
        mImageProcessor.setImageProcessorListener(this);

        mImageProcessor.setColorspace(ImageProcessor.Colorspace.UNDEFINED);
    }

    /**
     * Update displayed image of the ViewPager to make changes visible to the
     * user.
     *
     * @param bm bitmap to show
     */
    private void updateView(final BitmapWithMetadata bm, int page) {
        if (getActivity() != null) {
            View convertView = mImagePager.findViewWithTag(page);
            ImageView imageView = (ImageView) convertView
                    .findViewById(R.id.PDFPage);
            Bitmap bitmap = bm.getBitmap();
            float scale = getImageScale(bitmap);
            Bitmap newBitmap = Bitmap.createScaledBitmap(bitmap, (int) (bitmap.getWidth() * scale), (int) (bitmap.getHeight() * scale), true);
//            if (!bitmap.isRecycled() && !newBitmap.equals(bitmap)) {
//                bitmap.recycle();
//            }
            imageView.setImageBitmap(newBitmap);
        }
    }

    private float getImageScale(Bitmap bitmap) {
        int screenWidth = DisplayUtils.getInstance(getContext()).getScreenWidth();
        int screenHeight = DisplayUtils.getInstance(getContext()).getScreenHeight();
        float widthScale = (float) screenWidth / bitmap.getWidth();
        float heightScale = (float) screenHeight / bitmap.getHeight();
        return Math.min(widthScale, heightScale);
    }

    private void addImageColors() {
        mStateColorBeanList.add(new StateColorBean(R.drawable.fx_photo2pdf_edit_image_color_none));
        mStateColorBeanList.add(new StateColorBean(R.drawable.fx_photo2pdf_edit_image_color_ful));
        mStateColorBeanList.add(new StateColorBean(R.drawable.fx_photo2pdf_edit_image_color_black_and_white));
        mStateColorBeanList.add(new StateColorBean(R.drawable.fx_photo2pdf_edit_image_color_gray));
        mEditImageRecyclerViewColorState.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.HORIZONTAL, false));
        mStateColorAdapter = new StateColorAdapter(getActivity(), mStateColorBeanList);
        mEditImageRecyclerViewColorState.setHasFixedSize(true);
        mEditImageRecyclerViewColorState.setAdapter(mStateColorAdapter);
        mStateColorAdapter.setOnItemClickListener(new StateColorAdapter.ItemClickListener() {

            @Override
            public void onItemClick(View v, int position, ImageProcessor.Colorspace colorspace, RecyclerView.ViewHolder viewHolder) {
                imageColorsSelect(colorspace);
            }

        });
    }


    private void imageColorsSelect(ImageProcessor.Colorspace colorspace) {
        state = COLORSPACE;
        mImageProcessor.setColorspace(colorspace);
        mImageProcessor.computePreview();
        outgoingChange = true;
    }

    private void seekBarChanged(ToastSeekBar seekBar, int progress, String useFor) {
        if (useFor.equals("brightness")) {
            int brightnessLevel = (int) ((progress / (float) seekBar.getMax()) * (8));
            state = "brightness";
            mImageProcessor.setBrightnessLevel(brightnessLevel);
        } else if (useFor.equals("contrast")) {
            int contrastLevel = (int) ((progress / (float) seekBar.getMax()) * (5));
            state = "contrast";
            mImageProcessor.setContrastLevel(contrastLevel);
        }
        mImageProcessor.computePreview();
        outgoingChange = true;
    }


    @Override
    public void onBackPressed() {

        if (getActivity() != null) {
            if (reset()) return;
            getActivity().finish();
        }
        if (mImageProcessor != null)
            mImageProcessor.close();
    }

    private boolean reset() {
        if (mEditImageTwoToolbar.getVisibility() == View.VISIBLE) {
            mEditImageTwoToolbar.setVisibility(View.GONE);
            mEditImageOneToolbar.setVisibility(View.VISIBLE);
            mEditImageRecyclerViewColorState.setVisibility(View.GONE);
            mLlStateColorBg.setVisibility(View.GONE);
            mEditImageBrightnessSeekBar.setVisibility(View.GONE);
            mEditImageContrastSeekBar.setVisibility(View.GONE);
            mSaveButton.setText(R.string.scan_string_save);
            updateButtonState();

            doneSelectStatus();
            return true;
        }
        return false;
    }

    private void doneSelectStatus() {
            for (int i = 0; i < mStateColorBeanList.size(); i++) {
                if(i==0){
                    mStateColorBeanList.get(i).setSelected(true);
                    imageColorsSelect(ImageProcessor.Colorspace.UNDEFINED);
                }else{
                    mStateColorBeanList.get(i).setSelected(false);
                }
        }
        mStateColorAdapter.notifyUpdateData();
        seekBarChanged(mEditImageContrastSeekBar, mContrast, "contrast");
        mEditImageContrastSeekBar.reset(mContrast);
        seekBarChanged(mEditImageBrightnessSeekBar, mBrightness, "brightness");
        mEditImageBrightnessSeekBar.reset(mBrightness);

    }
}
