/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.statecolor;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.pdfscan.R;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.luratech.android.appframework.ImageProcessor;

import java.util.List;

public class StateColorAdapter extends SuperAdapter<StateColorBean> {

    private List<StateColorBean> mStateColorBeanList;
    private Context mContext;

    public StateColorAdapter(Context context, List<StateColorBean> stateColorBeanList) {
        super(context);
        mContext = context;
        mStateColorBeanList = stateColorBeanList;
        mStateColorBeanList.get(0).setSelected(true);
    }


    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    public StateColorBean getDataItem(int position) {
        return mStateColorBeanList.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        SuperViewHolder viewHolder = new StateColorAdapter.ItemViewHolder(LayoutInflater.from(getContext()).inflate(R.layout
                .fx_photo2pdf_edit_image_state_color_item, parent, false));
        return viewHolder;
    }

    @Override
    public int getItemCount() {
        return mStateColorBeanList.size();
    }


    class ItemViewHolder extends SuperViewHolder {
        private ImageView mIvImg, mIvStateBg;
        private View mViewMargin;

        public ItemViewHolder(View viewHolder) {
            super(viewHolder);
            mIvImg = itemView.findViewById(R.id.iv_state_img);
            mViewMargin = itemView.findViewById(R.id.view_state_margin);
            mIvStateBg = itemView.findViewById(R.id.iv_state_bg);

        }

        @Override
        public void bind(BaseBean data, int position) {
            StateColorBean stateColorBean = (StateColorBean) data;
            mIvImg.setImageResource(stateColorBean.getImg());
            mIvStateBg.setImageResource(R.drawable.fx_photo2pdf_editimg_color_border);
            if (position == mStateColorBeanList.size() - 1) {
                mViewMargin.setVisibility(View.GONE);
            }
            ThemeUtil.setTintList(mIvStateBg, ThemeUtil.getItemIconColor(mContext));
            if (stateColorBean.isSelected()) {
                mIvStateBg.setVisibility(View.VISIBLE);
            } else {
                mIvStateBg.setVisibility(View.INVISIBLE);
            }
        }

        @Override
        public void onClick(View v) {
            int position  = getAdapterPosition();

            for (int i = 0; i < mStateColorBeanList.size(); i++) {
                if (i == position) {
                    mStateColorBeanList.get(position).setSelected(true);
                } else {
                    mStateColorBeanList.get(i).setSelected(false);
                }
            }

            mItemClickListener.onItemClick(v, position, getColorSpaceByPosition(position), ItemViewHolder.this);
            notifyUpdateData();
        }
    }

    private ItemClickListener mItemClickListener;

    public void setOnItemClickListener(ItemClickListener listener) {
        mItemClickListener = listener;
    }

    public ImageProcessor.Colorspace getColorSpaceByPosition(int position) {
        ImageProcessor.Colorspace colorspace = null;
        switch (position) {
            case 0:
                colorspace = ImageProcessor.Colorspace.UNDEFINED;
                break;
            case 1:
                colorspace = ImageProcessor.Colorspace.RGBA_WB;
                break;
            case 2:
                colorspace = ImageProcessor.Colorspace.BITONAL;
                break;
            case 3:
                colorspace = ImageProcessor.Colorspace.GRAYSCALE;
                break;
            default:
                break;
        }
        return colorspace;
    }

    public interface ItemClickListener {
        void onItemClick(View v, int position, ImageProcessor.Colorspace colorspace, RecyclerView.ViewHolder viewHolder);
    }

}