/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.takephotolist;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;

import java.util.ArrayList;
import java.util.Collections;

import static com.foxit.pdfscan.NumberConstant.FIVE;
import static com.foxit.pdfscan.NumberConstant.ONE;

public class TakePhotoListAdapter extends SuperAdapter<TakePhotoListInfo> implements TakePhotoTouchHelper.ItemTouchCallback {
    private ArrayList<TakePhotoListInfo> mTakePhotoListInfo = new ArrayList<>();
    private int mScreenWidth = 0;

    public TakePhotoListAdapter(Context context, ArrayList<TakePhotoListInfo> takePhotoListInfo) {
        super(context);
        this.mTakePhotoListInfo = takePhotoListInfo;
        mScreenWidth = DisplayUtils.getInstance(getContext()).getScreenWidth();
    }


    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    public TakePhotoListInfo getDataItem(int position) {
        return mTakePhotoListInfo.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        SuperViewHolder viewHolder = new ItemViewHolder(LayoutInflater.from(getContext()).inflate(R.layout
                .fx_photo2pdf_item_take_photo, parent, false));
        return viewHolder;
    }

    @Override
    public int getItemCount() {
        return mTakePhotoListInfo.size();
    }


    @Override
    public void onMove(int fromPosition, int toPosition) {
        if (fromPosition < toPosition) {
            for (int i = fromPosition; i < toPosition; i++) {
                swap(i, i + 1);
            }
        } else {
            for (int i = fromPosition; i > toPosition; i--) {
                swap(i, i - 1);
            }
        }
        notifyItemMoved(fromPosition, toPosition);
    }


    private void swap(int dst, int src) {
        Collections.swap(mTakePhotoListInfo, dst, src);
    }

    class ItemViewHolder extends SuperViewHolder {
        private ImageView mIvPhoto;

        public ItemViewHolder(View viewHolder) {
            super(viewHolder);
            mIvPhoto = itemView.findViewById(R.id.scanner_take_photo_img);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) mIvPhoto.getLayoutParams();
            lp.width = mScreenWidth / FIVE - ONE;
            mIvPhoto.setLayoutParams(lp);

        }

        @Override
        public void bind(BaseBean data, int position) {
            TakePhotoListInfo itemInfo = (TakePhotoListInfo) data;
            mIvPhoto.setImageBitmap((itemInfo.getBitmap()));
        }

        @Override
        public void onClick(View v) {
            int position = getAdapterPosition();
            mItemClickListener.onItemClick(v, position, ItemViewHolder.this);
        }
    }

    private ItemClickListener mItemClickListener;

    public void setOnItemClickListener(ItemClickListener listener) {
        mItemClickListener = listener;
    }

    public interface ItemClickListener {
        void onItemClick(View v, int position, RecyclerView.ViewHolder viewHolder);
    }


    public Bitmap zoomBitmap(Bitmap mBitmap) {
        Bitmap returnBm = null;
        float hh = 360f;
        int w = mBitmap.getWidth();
        int be = 1;
        if (w > hh) {
            be = (int) (w / hh);
        }
        if (be <= 0)
            be = 1;
        Matrix matrix = new Matrix();
        matrix.setScale(1f / be, 1f / be);
        try {
            mBitmap = Bitmap.createBitmap(mBitmap, 0, 0, mBitmap.getWidth(),
                    mBitmap.getHeight(), matrix, true);
        } catch (OutOfMemoryError e) {
        }
        if (returnBm == null) {
            returnBm = mBitmap;
        }
//        if (mBitmap != returnBm) {
//            mBitmap.recycle();
//        }
        return returnBm;
    }

    public Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap returnBm = null;
        Matrix matrix = new Matrix();
        matrix.postRotate(degree);
        try {
            returnBm = Bitmap.createBitmap(bm, 0, 0, bm.getWidth(), bm.getHeight(), matrix, true);
        } catch (OutOfMemoryError e) {
        }
        if (returnBm == null) {
            returnBm = bm;
        }
//        if (bm != returnBm) {
//            bm.recycle();
//        }
        return returnBm;
    }
}