/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.utils;

import android.content.Intent;
import android.os.Bundle;

import com.foxitsoftware.mobile.scanning.DocumentSession;
import com.foxitsoftware.mobile.scanning.DocumentSessionManagerFactory;

public class SessionIntentUtils {

    private static final String EXTRA_DOCUMENT_SESSIONID = "com.luratech.android.appframework.DocumentSessionId";

    /// TODO: what if sessionId is 0, what if sessionId is not set (null) -> should throw
    public static DocumentSession getSession(Intent intent) throws Exception {
        return getSession(intent.getExtras());
    }

    public static DocumentSession getSession(Bundle bundle) {
        int sessionId = (int) bundle.get(EXTRA_DOCUMENT_SESSIONID);
        return DocumentSessionManagerFactory.getInstance().getSessionForId(sessionId);
    }

    public static DocumentSession tryGetSession(Intent intent) {
        return tryGetSession(intent.getExtras());
    }

    public static DocumentSession tryGetSession(Bundle bundle) {
        try {
            return getSession(bundle);
        } catch (Exception exception) {
            return null;
        }
    }

    public static void saveSessionId(Intent intent, DocumentSession documentSession) {
        intent.putExtra(EXTRA_DOCUMENT_SESSIONID, DocumentSessionManagerFactory.getInstance().getSessionId(documentSession));
    }

    public static void saveSessionId(Bundle bundle, DocumentSession documentSession) {
        bundle.putInt(EXTRA_DOCUMENT_SESSIONID, DocumentSessionManagerFactory.getInstance().getSessionId(documentSession));
    }

}
