/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.foxit.pdfscan.R;
import com.luratech.android.appframework.Document;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BrowserItemView extends FrameLayout {
    private static final float Kilo = 1000.0f;
    private static final float Mega = Kilo * Kilo;
    private Document document;

    public BrowserItemView(Context context) {
        super(context);
        initComponent(context);
    }

    public BrowserItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initComponent(context);
    }

    private void initComponent(Context context) {
        LayoutInflater inflater = LayoutInflater.from(context);
        final View v = inflater.inflate(R.layout.fx_photo2pdf_fragment_browser_item, null,
                false);

        this.addView(v);
    }

    public void setItem(Document document) {
        this.document = document;
        ImageView imageView = (ImageView) findViewById(R.id.browser_item_thumbnail);
        TextView nameText = (TextView) findViewById(R.id.browser_item_name);
        TextView dateText = (TextView) findViewById(R.id.browser_item_created);
        TextView pageText = (TextView) findViewById(R.id.browser_item_page_count);
        TextView sizeText = (TextView) findViewById(R.id.browser_item_file_size);
        ImageView typeView = (ImageView) findViewById(R.id.browser_item_type);

        nameText.setText(document.getDocumentName());
        dateText.setText(formatDate(document.getDate()));
        pageText.setText(String.valueOf(document.getPageCount()));
        sizeText.setText(formatFileSize(document.getFileSize()));
        switch (document.getDocumentType()) {
            case PDF:
//			typeView.setImageResource(R.drawable.browser_doctype_pdf);
                break;
            case Image:
            case ImageSeries:
//			typeView.setImageResource(R.drawable.browser_doctype_imageseries);
                break;

            default:
                break;
        }

        Bitmap thumbnail = document.getThumbnail();
        if (thumbnail != null)
            imageView.setImageBitmap(thumbnail);
    }

    public Document getDocument() {
        return document;
    }

    private String formatDate(Date date) {
        DateFormat df = SimpleDateFormat
                .getDateInstance(SimpleDateFormat.SHORT);
        return df.format(date);
    }

    private String formatFileSize(int size) {
        if (size < Kilo)
            return String.format(Locale.getDefault(), "%d B", size);
        else if (size < Mega)
            return String.format(Locale.getDefault(), "%.2f KB", size / Kilo);
        else
            return String.format(Locale.getDefault(), "%.2f MB", size / Mega);
    }

}
