/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.foxit.pdfscan.R;

public class ScannerPreviewBarView extends RelativeLayout {

    private TextView pictureCount;
    private Activity activity;

    public ScannerPreviewBarView(Context context) {
        super(context);
        initComponent(context);
    }

    public ScannerPreviewBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initComponent(context);
    }

    private void initComponent(Context context) {
        activity = (Activity) getContext();
        LayoutInflater inflater = LayoutInflater.from(context);
        final View v = inflater.inflate(R.layout.fx_photo2pdf_fragment_scanner_preview_bar, null, false);
        pictureCount = (TextView) v.findViewById(R.id.scan_doc_preview_button);
        this.addView(v);
    }

    public int getPictureCount() {
        CharSequence text = pictureCount.getText();
        if (text == null || text.length() == 0) {
            return 0;
        }
        return Integer.valueOf(text.toString());
    }

    public void setPictureCount(int count) {
        if (count > 0) {
            pictureCount .setVisibility(View.VISIBLE);
        } else {
            pictureCount.setVisibility(View.INVISIBLE);
        }
        pictureCount.setText(String.valueOf(count));
    }

    public TextView getPreviewPicture() {
        return pictureCount;
    }
}
