/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;

import com.foxit.pdfscan.R;

import java.lang.reflect.Field;

import androidx.fragment.app.FragmentActivity;

public class UilBaseActivity extends FragmentActivity {
    protected boolean mIsDestroyed;
    private boolean mClickable = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mIsDestroyed = false;

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
        setThemeFullScreen(this);
        setTheme(R.style.Theme_Read_White);
        setThemeNeedMenuKey(this);
        UilAppManager.getAppManager().addActivity(this);
    }

    private void setThemeFullScreen(Activity activity) {
        activity.requestWindowFeature(Window.FEATURE_NO_TITLE);
        activity.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
    }

    private void setThemeNeedMenuKey(Activity activity) {
        if (Build.VERSION.SDK_INT >= 22) {
            try {
                WindowManager.LayoutParams layoutParams = activity.getWindow().getAttributes();
                Field field = WindowManager.LayoutParams.class.getField("needsMenuKey");
                field.setInt(layoutParams, WindowManager.LayoutParams.class.getField("NEEDS_MENU_SET_TRUE").getInt(null));
            } catch (Exception ignored) {
                ignored.printStackTrace();
            }
        } else {
            try {
                activity.getWindow().addFlags(WindowManager.LayoutParams.class.getField("FLAG_NEEDS_MENU_KEY").getInt(null));
            } catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mIsDestroyed = true;
        UilAppManager.getAppManager().finishActivity(this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        mClickable = true;
    }

    protected boolean isClickable() {
        return mClickable;
    }

    protected void lockClick() {
        mClickable = false;
    }

    @SuppressLint("RestrictedApi")
    @Override
    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        if (isClickable()) {
            lockClick();
            super.startActivityForResult(intent, requestCode, options);
        }
    }
}
