/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.foxit.pdfscan.ActRequestCode;
import com.foxit.pdfscan.R;
import com.foxit.pdfscan.ScannerSession;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.uiextensions.theme.BaseThemeAdapter;
import com.foxit.uiextensions.theme.IThemeChangeObserver;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.display.SimpleBitmapDisplayer;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;

import java.util.ArrayList;
import java.util.List;

public class UilLocalAlbum extends UilBaseActivity implements IThemeChangeObserver {
    public static final String LOCAL_FOLDER_PATH = "local_folder_path";
    public static final String LOCAL_FOLDER_NAME = "local_folder_name";

    ListView mFolderListView;
    ImageView mLoadingProgress;
    List<String> mFolderPathes;
    List<String> mFolderNames;
    private UilFilterImageView mAlbumBackButton;
    private LinearLayout mAlbumLlRoot;
    private RelativeLayout mAlbumRlTitleBar;
    private TextView mTitle;
    private View mTitleDivider;
    private TextView mLoadingProgressText;
    FolderAdapter mAdapter;
    private int mNightMode = -1;
    private boolean mSingleChoose;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mSingleChoose = getIntent().getBooleanExtra(ScannerSession.EXTRA_SINGLE_CHOOSE, false);
        setContentView(R.layout.fx_photo2pdf_local_album);
        mNightMode = getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
        mAlbumLlRoot = findViewById(R.id.scanner_local_album_ll_root);
        mAlbumRlTitleBar = findViewById(R.id.scanner_locao_album_rl_title_bar);
        mTitle = findViewById(R.id.scanner_local_album_title);
        mTitleDivider = findViewById(R.id.scanner_local_album_title_divider);
        mAlbumBackButton = findViewById(R.id.scanner_local_album_back_button);
        mLoadingProgressText = findViewById(R.id.scanner_local_album_progress_text);
        ThemeUtil.setTintList(mAlbumBackButton, ThemeUtil.getItemIconColor(this));
        mAlbumBackButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                UilLocalImageHelper.getInstance(getApplicationContext()).clear();
                finish();
            }
        });

        mFolderListView = (ListView) findViewById(R.id.scanner_local_album_folder_list);
        mFolderListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Intent intent = new Intent(UilLocalAlbum.this, UilLocalAlbumDetail.class);
                intent.putExtra(UilLocalAlbum.LOCAL_FOLDER_PATH, mFolderPathes.get(i));
                intent.putExtra(UilLocalAlbum.LOCAL_FOLDER_NAME, mFolderNames.get(i));
                intent.putExtra(ScannerSession.EXTRA_SINGLE_CHOOSE, mSingleChoose);
//                intent.setFlags(Intent.FLAG_ACTIVITY_FORWARD_RESULT);
                startActivityForResult(intent,ActRequestCode.REQ_SCAN_PHOTO_LIBRARY);
            }
        });

        mLoadingProgress = (ImageView) findViewById(R.id.scanner_local_album_progress);
        ThemeUtil.setTintList(mLoadingProgress, ThemeUtil.getPrimaryIconColor(this));
        Animation animation = AnimationUtils.loadAnimation(this, R.anim.fx_photo2pdf_rotate_loading);
        mLoadingProgress.startAnimation(animation);

        UilLocalImageHelper.getInstance(getApplicationContext()).loadImages(UilLocalAlbum.this, new Runnable() {
            @Override
            public void run() {
                if (!mIsDestroyed) {
                    mFolderListView.setAdapter(mAdapter = new FolderAdapter(UilLocalAlbum.this,
                            UilLocalImageHelper.getInstance(getApplicationContext()).getFolders()));
                    mLoadingProgress.clearAnimation();
                    ((View) mLoadingProgress.getParent()).setVisibility(View.GONE);
                    mFolderListView.setVisibility(View.VISIBLE);
                }
            }
        });
        if (ThemeConfig.getInstance(this).getAdapter() == null) {
            ThemeConfig.getInstance(this).setAdapter(new BaseThemeAdapter());
        }
        ThemeConfig.getInstance(this).getAdapter().registerThemeChangeObserver(this);
    }

    @Override
    public void onThemeChanged(String type, int color) {
        ThemeUtil.setTintList(mAlbumBackButton, ThemeUtil.getItemIconColor(this));
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mNightMode != (newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK)) {
            mNightMode = newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK;
            setDarkModeColor();
        }
    }

    public void setDarkModeColor() {
        mAlbumLlRoot.setBackgroundColor(getResources().getColor(R.color.b1));
        mAlbumRlTitleBar.setBackgroundColor(getResources().getColor(R.color.b2));
        mTitle.setTextColor(getResources().getColor(R.color.t4));
        mTitleDivider.setBackgroundColor(getResources().getColor(R.color.p1));
        ThemeUtil.setTintList(mLoadingProgress, ThemeUtil.getPrimaryIconColor(this));
        mLoadingProgressText.setTextColor(getResources().getColor(R.color.t3));
        mFolderListView.setDivider(getResources().getDrawable(R.color.b1));
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onDestroy() {
        ThemeConfig.getInstance(this).getAdapter().unregisterThemeChangeObserver(this);
        super.onDestroy();
    }

    @Override
    public void onBackPressed() {
        UilLocalImageHelper.getInstance(getApplicationContext()).clear();
        super.onBackPressed();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            switch (requestCode) {
                case ActRequestCode.REQ_SCAN_PHOTO_LIBRARY:
                    setResult(RESULT_OK);
                    finish();
                    break;
                default:
                    break;
            }
        }
    }

    class FolderAdapter extends BaseAdapter {
        Context mContext;
        List<UilPhotoDirectory> mFolders;
        DisplayImageOptions mDisplayOptions;

        FolderAdapter(Context context, List<UilPhotoDirectory> folders) {
            this.mContext = context;
            this.mFolders = folders;
            mFolderPathes = new ArrayList<>();
            mFolderNames = new ArrayList<>();

            mDisplayOptions = new DisplayImageOptions.Builder()
                    .cacheInMemory(true)
                    .cacheOnDisk(false)
                    .showImageForEmptyUri(R.drawable.fx_photo2pdf_file_type_pdf)
                    .showImageOnFail(R.drawable.fx_photo2pdf_file_type_pdf)
                    .showImageOnLoading(R.drawable.fx_photo2pdf_file_type_pdf)
                    .bitmapConfig(Bitmap.Config.RGB_565)
                    .displayer(new SimpleBitmapDisplayer())
                    .build();

            for (UilPhotoDirectory dir : folders) {
                mFolderPathes.add(dir.getPath());
                mFolderNames.add(dir.getName());
            }
        }

        @Override
        public int getCount() {
            return mFolders.size();
        }

        @Override
        public Object getItem(int i) {
            return null;
        }

        @Override
        public long getItemId(int i) {
            return 0;
        }

        @Override
        public View getView(int i, View convertView, ViewGroup viewGroup) {
            ViewHolder viewHolder;
            if (convertView == null || convertView.getTag() == null) {
                viewHolder = new ViewHolder();
                convertView = LayoutInflater.from(mContext).inflate(R.layout.fx_photo2pdf_item_albumfoler, null);
                viewHolder.imageView = (ImageView) convertView.findViewById(R.id.fx_photo2pdf_item_albumfoler_imageView);
                viewHolder.textView = (TextView) convertView.findViewById(R.id.fx_photo2pdf_item_albumfoler_textview);
                convertView.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) convertView.getTag();
            }
            convertView.setBackground(mContext.getResources().getDrawable(R.drawable.fx_photo2pdf_white_gray_bg_selector));
            viewHolder.textView.setTextColor(mContext.getResources().getColor(R.color.t4));
            String name = mFolders.get(i).getName();
            viewHolder.textView.setText(name + "(" + mFolders.get(i).getPhotos().size() + ")");
            if (mFolders.get(i).getPhotos().size() > 0) {
                ImageLoader.getInstance().displayImage(
                        mFolders.get(i).getPhotos().get(0).getThumbnailUri(),
                        new ImageViewAware(viewHolder.imageView),
                        mDisplayOptions,
                        new ImageSize(DisplayUtils.getInstance(mContext).getScreenWidth() / 4, 0),
                        null, null);
            }
            return convertView;
        }

        private class ViewHolder {
            ImageView imageView;
            TextView textView;
        }
    }
}
