/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.text.TextUtils;

import com.foxit.pdfscan.utils.FileUtils;

import java.util.ArrayList;
import java.util.List;

public class UilPhotoDirectory {
    private String id;
    private String name;
    private String path;
    private final List<UilPhoto> photos = new ArrayList<>();

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof UilPhotoDirectory)) return false;

        UilPhotoDirectory directory = (UilPhotoDirectory) o;
        if (!TextUtils.isEmpty(id) && !TextUtils.isEmpty(directory.id)) {
            return TextUtils.equals(id, directory.id) && TextUtils.equals(name, directory.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (TextUtils.isEmpty(id) && TextUtils.isEmpty(name)) {
            return 0;
        }

        int result = (id != null ? id.hashCode() : 0) * 31;
        result += (name != null ? name.hashCode() : 0);
        return result;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<UilPhoto> getPhotos() {
        return photos;
    }

    public List<String> getPhotoPaths() {
        List<String> paths = new ArrayList<>(photos.size());
        for (UilPhoto photo : photos) {
            paths.add(photo.getOriginalUri());
        }
        return paths;
    }

    public void addPhoto(int id, String origPath, String thumbPath, int orientation) {
        if (FileUtils.isFileExist(origPath)) {
            photos.add(new UilPhoto(id, origPath, thumbPath, orientation));
        }
    }

}
