/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions;

/**
 * Interface definition for a callback to be invoked when a specify UI element is clicked.
 */
public interface IUIInteractionEventListener {
    /**
     * Called when a UI element is clicked.
     *
     * @param element The name of UI element that has been clicked.
     * @param userData Reserved, not used at this time.
     */
    void onUIElementClicked(String element, String userData);

    /** Element names */

    /** The name of panel list button that on the toolbar. */
    String Reading_Panel = "Reading_Panel";
    /** The name of bookmark tab that on the panel. */
    String Reading_Panel_Bookmark = "Reading_Panel_Bookmark";
    /** The name of outline tab that on the panel. */
    String Reading_Panel_Outline = "Reading_Panel_Outline";
    /** The name of comment tab that on the panel. */
    String Reading_Panel_Comment = "Reading_Panel_Comment";
    /** The name of attachment tab that on the panel. */
    String Reading_Panel_Attachment = "Reading_Panel_Attachment";
    /** The name of signature tab that on the panel. */
    String Reading_Panel_DigitalSignature = "Reading_Panel_DigitalSignature";
    /** The name of view settings button that on the toolbar. */
    String Reading_View = "Reading_View";
    /** The name of SinglePage button that on the view settings. */
    String Reading_View_SinglePage = "Reading_View_SinglePage";
    /** The name of Facing button that on the view settings. */
    String Reading_View_Facing = "Reading_View_Facing";
    /** The name of CoverFacing button that on the view settings. */
    String Reading_View_CoverFacing = "Reading_View_CoverFacing";
    /** The name of Day button that on the view settings. */
    String Reading_View_Day = "Reading_View_Day";
    /** The name of Night button that on the view settings. */
    String Reading_View_Night = "Reading_View_Night";
    /** The name of PageColor button that on the view settings. */
    String Reading_View_PageColor = "Reading_View_PageColor";
    /** The name of ContinuousScrolling button that on the view settings. */
    String Reading_View_ContinuousScrolling = "Reading_View_ContinuousScrolling";
    /** The name of Right to Left button that on the view settings. */
    String Reading_View_Right_to_Left = "Reading_View_Right_to_Left";
    /** The name of FitPage button that on the view settings. */
    String Reading_View_FitPage = "Reading_View_FitPage";
    /** The name of FitWidth button that on the view settings. */
    String Reading_View_FitWidth = "Reading_View_FitWidth";
    /** The name of Reflow button that on the view settings. */
    String Reading_View_Reflow = "Reading_View_Reflow";
    /** The name of CropMode button that on the view settings. */
    String Reading_View_CropMode = "Reading_View_CropMode";
    /** The name of Speak button that on the view settings. */
    String Reading_View_Speak = "Reading_View_Speak";
    /** The name of AutoFlip button that on the view settings. */
    String Reading_View_AutoFlip = "Reading_View_AutoFlip";
    /** The name of RotateView button that on the view settings. */
    String Reading_View_RotateView = "Reading_View_RotateView";
    /** The name of PanZoom button that on the view settings. */
    String Reading_View_PanZoom = "Reading_View_PanZoom";
    /** The name of Thumbnial button that on the toolbar. */
    String Reading_Thumbnial = "Reading_Thumbnial";
    /** The name of Bookmark button that on the toolbar. */
    String Reading_Bookmark = "Reading_Bookmark";
    /** The name of Home button that on the tool tab. */
    String Reading_ToolsTab_Home = "Reading_ToolsTab_Home";
    /** The name of Edit button that on the tool tab. */
    String Reading_ToolsTab_Edit = "Reading_ToolsTab_Edit";
    /** The name of Comment button that on the tool tab. */
    String Reading_ToolsTab_Comment = "Reading_ToolsTab_Comment";
    /** The name of Drawing button that on the tool tab. */
    String Reading_ToolsTab_Drawing = "Reading_ToolsTab_Drawing";
    /** The name of View button that on the tool tab. */
    String Reading_ToolsTab_View = "Reading_ToolsTab_View";
    /** The name of Form button that on the tool tab. */
    String Reading_ToolsTab_Form = "Reading_ToolsTab_Form";
    /** The name of FillSig button that on the tool tab. */
    String Reading_ToolsTab_FillSign = "Reading_ToolsTab_FillSign";
    /** The name of AddTools button that on the toolbar. */
    String Reading_HomeBar_AddTools = "Reading_HomeBar_AddTools";
    /** The name of the Text button in the toolbar the Edit TAB. */
    String Reading_EditBar_Text = "Reading_Edit_Text";
    /** The name of the Image button in the toolbar the Edit TAB. */
    String Reading_EditBar_Image = "Reading_Edit_Image";
    /** The name of the Audio button in the toolbar the Edit TAB. */
    String Reading_EditBar_Audio = "Reading_Edit_Audio";
    /** The name of the Video button in the toolbar the Edit TAB. */
    String Reading_EditBar_Video = "Reading_EditBar_Video";
    /** The name of the Note button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Note = "Reading_CommentBar_Note";
    /** The name of the Attachment button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Attachment = "Reading_CommentBar_Attachment";
    /** The name of the Stamp button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Stamp = "Reading_CommentBar_Stamp";
    /** The name of the TypeWriter button in the toolbar the Comment TAB. */
    String Reading_CommentBar_TypeWriter = "Reading_CommentBar_TypeWriter";
    /** The name of the Callout button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Callout = "Reading_CommentBar_Callout";
    /** The name of the Textbox button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Textbox = "Reading_CommentBar_Textbox";
    /** The name of the Highlight button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Highlight = "Reading_CommentBar_Highlight";
    /** The name of the Underline button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Underline = "Reading_CommentBar_Underline";
    /** The name of the Squiggly button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Squiggly = "Reading_CommentBar_Squiggly";
    /** The name of the Strikeout button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Strikeout = "Reading_CommentBar_Strikeout";
    /** The name of the InsertText button in the toolbar the Comment TAB. */
    String Reading_CommentBar_InsertText = "Reading_CommentBar_InsertText";
    /** The name of the ReplaceText button in the toolbar the Comment TAB. */
    String Reading_CommentBar_ReplaceText = "Reading_CommentBar_ReplaceText";
    /** The name of the AreaHighlight button in the toolbar the Comment TAB. */
    String Reading_CommentBar_AreaHighlight = "Reading_CommentBar_AreaHighlight";
    /** The name of the Distance button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Distance = "Reading_CommentBar_Distance";
    /** The name of the Image button in the toolbar the Comment TAB. */
    String Reading_CommentBar_Image = "Reading_CommentBar_Image";
    /** The name of the Pencil button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Pencil = "Reading_DrawingBar_Pencil";
    /** The name of the Highlight button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Highlight = "Reading_DrawingBar_Highlight";
    /** The name of the Eraser button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Eraser = "Reading_DrawingBar_Eraser";
    /** The name of the Rectangle button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Rectangle = "Reading_DrawingBar_Rectangle";
    /** The name of the Oval  button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Oval = "Reading_DrawingBar_Oval";
    /** The name of the Line button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Line = "Reading_DrawingBar_Line";
    /** The name of the Arrow button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Arrow = "Reading_DrawingBar_Arrow";
    /** The name of the Polyline button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Polyline = "Reading_DrawingBar_Polyline";
    /** The name of the Polygon button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Polygon = "Reading_DrawingBar_Polygon";
    /** The name of the Cloud button in the toolbar the Drawing TAB. */
    String Reading_DrawingBar_Cloud = "Reading_DrawingBar_Cloud";
    /** The name of the TextField button in the toolbar the Form TAB. */
    String Reading_FormBar_TextField = "Reading_FormBar_TextField";
    /** The name of the CheckBox button in the toolbar the Form TAB. */
    String Reading_FormBar_CheckBox = "Reading_FormBar_CheckBox";
    /** The name of the RadioButton button in the toolbar the Form TAB. */
    String Reading_FormBar_RadioButton = "Reading_FormBar_RadioButton";
    /** The name of the ListBox button in the toolbar the Form TAB. */
    String Reading_FormBar_ListBox = "Reading_FormBar_ListBox";
    /** The name of the ComboBox button in the toolbar the Form TAB. */
    String Reading_FormBar_ComboBox = "Reading_FormBar_ComboBox";
    /** The name of the SignatureField button in the toolbar the Form TAB. */
    String Reading_FormBar_SignatureField = "Reading_FormBar_SignatureField";
    /** The name of the ImageField button in the toolbar the Form TAB. */
    String Reading_FormBar_ImageField = "Reading_FormBar_ImageField";
    /** The name of the Reset button in the toolbar the Form TAB. */
    String Reading_FormBar_Reset = "Reading_FormBar_Reset";

    /** The name of the Appearance button in the toolbar the Form PopMenu. */
    String Reading_Annot_PopMenu_Appearance = "Reading_Annot_PopMenu_Appearance";
    /** The name of the Delete button in the toolbar the Form PopMenu. */
    String Reading_Annot_PopMenu_Delete = "Reading_Annot_PopMenu_Delete";


    /** The name of the TypeWriter button in the toolbar the FillSign TAB. */
    String Reading_FillSign_TypeWriter = "Reading_FillSign_TypeWriter";
    /** The name of the ComboText button in the toolbar the FillSign TAB. */
    String Reading_FillSign_ComboText = "Reading_FillSign_ComboText";
    /** The name of the V button in the toolbar the FillSign TAB. */
    String Reading_FillSign_V = "Reading_FillSign_V";
    /** The name of the X button in the toolbar the FillSign TAB. */
    String Reading_FillSign_X = "Reading_FillSign_X";
    /** The name of the Dot button in the toolbar the FillSign TAB. */
    String Reading_FillSign_Dot = "Reading_FillSign_Dot";
    /** The name of the Rectangle button in the toolbar the FillSign TAB. */
    String Reading_FillSign_Rectangle = "Reading_FillSign_Rectangle";
    /** The name of the Line button in the toolbar the FillSign TAB. */
    String Reading_FillSign_Line = "Reading_FillSign_Line";
    /** The name of the Predefined button in the toolbar the FillSign TAB. */
    String Reading_FillSign_Predefined = "Reading_FillSign_Predefined";
    /** The name of the Sign button in the toolbar the FillSign TAB. */
    String Reading_FillSign_Sign = "Reading_FillSign_Sign";

    /** The name of the more button on the top toolbar. */
    String Reading_Search = "Reading_Search";
    /** The button name of FileProperty in Protect in more buttons */
    String Reading_More_FileProperty = "Reading_More_FileProperty";
    /** The button name of Redaction in Protect in more buttons */
    String Reading_More_Protect_Redaction = "Reading_More_Protect_Redaction";
    /** The button name of ileEncryption in Protect in more buttons */
    String Reading_More_Protect_FileEncryption = "Reading_More_Protect_FileEncryption";
    /** The button name of rustedCertificates in Protect in more buttons */
    String Reading_More_Protect_TrustedCertificates = "Reading_More_Protect_TrustedCertificates";
    /** The button name of ImortComments in CommentField in more buttons */
    String Reading_More_CommentField_ImortComments = "Reading_More_CommentField_ImortComments";
    /** The button name of ExportComments in CommentField in more buttons */
    String Reading_More_CommentField_ExportComments = "Reading_More_CommentField_ExportComments";
    /** The button name of SummarizeComments in CommentField in more buttons */
    String Reading_More_CommentField_SummarizeComments = "Reading_More_CommentField_SummarizeComments";
    /** The button name of ResetFormFields in CommentField in more buttons */
    String Reading_More_CommentField_ResetFormFields = "Reading_More_CommentField_ResetFormFields";
    /** The button name of ImportFormFields in CommentField in more buttons */
    String Reading_More_CommentField_ImportFormFields = "Reading_More_CommentField_ImportFormFields";
    /** The button name of ExportFormFields in CommentField in more buttons */
    String Reading_More_CommentField_ExportFormFields = "Reading_More_CommentField_ExportFormFields";

    /** The name of the save as button in more button s*/
    String Reading_More_SaveAs = "Reading_More_SaveAs";
    /** The name of the ReduceFileSize button in more buttons */
    String Reading_More_ReduceFileSize = "Reading_More_ReduceFileSize";
    /** The name of the Print button in more buttons */
    String Reading_More_Print = "Reading_More_Print";
    /** The name of the Flatten button in more buttons */
    String Reading_More_Flatten = "Reading_More_Flatten";
    /** The name of the ScreenCapture button in more buttons */
    String Reading_More_ScreenCapture = "Reading_More_ScreenCapture";

    /** Click the button name of Comment in the popup menu in the blank area of the document */
    String Reading_LongPress_Comment = "Reading_LongPress_Comment";
    /** Click the button name of Redaction in the popup menu in the blank area of the document */
    String Reading_LongPress_Redaction = "Reading_LongPress_Redaction";
    /** Click the button name of Sign in the popup menu in the blank area of the document */
    String Reading_LongPress_Sign = "Reading_LongPress_Sign";
    /** Long press the name of the CopyText button in the text pop-up menu */
    String Reading_LongPress_CopyText = "Reading_LongPress_CopyText";
    /** Long press the name of the Highlight button in the text pop-up menu */
    String Reading_LongPress_Highlight = "Reading_LongPress_Highlight";
    /** Long press the name of the Underline button in the text pop-up menu */
    String Reading_LongPress_Underline = "Reading_LongPress_Underline";
    /** Long press the name of the Strikeout button in the text pop-up menu */
    String Reading_LongPress_Strikeout = "Reading_LongPress_Strikeout";
    /** Long press the name of the Squiggly button in the text pop-up menu */
    String Reading_LongPress_Squiggly = "Reading_LongPress_Squiggly";
    /** Long press the name of the Speak button in the text pop-up menu */
    String Reading_LongPress_Speak = "Reading_LongPress_Speak";
    /** The name of the button that opens the Gotopage dialog box */
    String Reading_GotoPage = "Reading_GotoPage";
    /** In full screen mode, click the bookmark button name */
    String Reading_FullScreen_Bookmark = "Reading_FullScreen_Bookmark";
    /** In full-screen mode, click any toolbar button name */
    String Reading_FullScreen_Toolbar = "Reading_FullScreen_Toolbar";
    /** In full-screen mode, drag the toolbar name */
    String Reading_FullScreen_Toolbar_Drag = "Reading_FullScreen_Toolbar_Drag";
    /** Drag the name of the toolbar on the tablet */
    String Reading_Toolbar_Drag = "Reading_Toolbar_Drag";
    /**The name of the multi-select button on the toolbar */
    String Reading_Toolbar_MultipleSelection = "Reading_Toolbar_MultipleSelection";
    /** This is an ink comment selected to pop up the identify text menu*/
    String Reading_Ink_Recognition_Text = "Reading_Ink_Recognition_Text";
}
