/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots;


import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.annots.Annot;

/**
 * interface definition for a callback to be invoked when flatten annotation or document.
 */
public abstract class IFlattenEventListener {

    /**
     * Called when a annotation.will be flattened.
     *
     * @param page  The {@link PDFPage} which flatten annotation.
     * @param annot The specified annotation will be flattened
     */
    public void onAnnotWillFlatten(PDFPage page, Annot annot) {
    }

    /**
     * Called when a annotation.has flattened.
     *
     * @param page The {@link PDFPage} which flatten annotation.
     * @param annot The specified annotation has flattened
     */
    public void onAnnotFlattened(PDFPage page, Annot annot) {

    }

    /**
     * Called when annotations.will be flattened.
     *
     * @param doc The {@link PDFDoc} which flatten annotations.
     */
    public void onAnnotsWillFlatten(PDFDoc doc) {

    }

    /**
     * Called when annotations.has flattened.
     *
     * @param doc The {@link PDFDoc} which flatten annotations.
     */
    public void onAnnotsFlattened(PDFDoc doc) {

    }
}
