/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.common;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;

import androidx.annotation.Nullable;

public class UIBtnImageView extends ImageView implements GestureDetector.OnGestureListener {
    private View mParentLayout;
    private OnClickListener mClickListener;
    private OnLongClickListener mLongClickListener;
    private GestureDetector mGestureDetector;
    private Context mContext;
    protected Paint mPaint = new Paint();
    private int mColor = 0;
    private ColorStateList mColorStateList;
    private boolean mIsChecked;

    public UIBtnImageView(Context context) {
        this(context, null, 0);
    }

    public UIBtnImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UIBtnImageView(Context context, View rootLayout) {
        this(context, null, 0);
        mParentLayout = rootLayout;
    }

    public UIBtnImageView(Context context,int color, View rootLayout) {
        this(context, null, 0);
        mParentLayout = rootLayout;
        mColor = color;
    }

    public UIBtnImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        mPaint.setDither(true);
        mPaint.setAntiAlias(true);

        mGestureDetector = new GestureDetector(context, this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!isEnabled() || mColorStateList != null) return super.onTouchEvent(event);

        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                setColorFilter(ThemeConfig.getInstance(mContext).getI2());
                mGestureDetector.onTouchEvent(event);
                return true;
            case MotionEvent.ACTION_UP:
            case MotionEvent.ACTION_CANCEL:
                this.setColorFilter(null);
                break;
            default:
        }
        mGestureDetector.onTouchEvent(event);
        return super.onTouchEvent(event);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (mColorStateList == null) {
            if (isEnabled()) {
                setColorFilter(Color.TRANSPARENT);
            } else {
                setColorFilter(ThemeConfig.getInstance(mContext).getI2());
            }
        }
    }

    public void setChecked(boolean checked) {
        mIsChecked = checked;
        invalidate();
    }

    public boolean isChecked() {
        return mIsChecked;
    }

    @Override
    public void draw(Canvas canvas) {
        if (mIsChecked) {
            mPaint.setStyle(Paint.Style.FILL);
            int color = 0;
            if(mColor == 0){
                color = AppResource.getColor(mContext, R.color.p2);
            }else{
                color = mColor;
            }
            mPaint.setColor(color);
            int offset = AppDisplay.dp2px(2);
            canvas.drawRoundRect(new RectF(offset, offset, getWidth() - offset, getHeight() - offset),
                    offset, offset, mPaint);
        }
        super.draw(canvas);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    @Override
    public void setOnClickListener(@Nullable OnClickListener l) {
        super.setOnClickListener(l);
        mClickListener = l;
    }

    @Override
    public void setOnLongClickListener(@Nullable OnLongClickListener l) {
        super.setOnLongClickListener(l);
        mLongClickListener = l;
    }

    @Override
    public boolean onDown(MotionEvent e) {
        return true;
    }

    @Override
    public void onShowPress(MotionEvent e) {

    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        if (mClickListener != null) {
            if (mParentLayout != null) {
                mClickListener.onClick(mParentLayout);
            } else {
                mClickListener.onClick(UIBtnImageView.this);
            }
        }
        return true;
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    @Override
    public void onLongPress(MotionEvent e) {
        if (mLongClickListener != null) {
            mLongClickListener.onLongClick(this);
        }
    }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    public void setColorStateList(ColorStateList colorStateList) {
        mColorStateList = colorStateList;
        ThemeUtil.setTintList(this, colorStateList);
    }
    public void invalidate(int color){
        mColor = color;
        invalidate();
    }

}