/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.fillsign;


import android.graphics.PointF;
import android.graphics.RectF;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.annots.AnnotUndoItem;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;

import java.util.ArrayList;

public abstract class FillSignUndoItem extends AnnotUndoItem {
    int mType;
    int mRotation;
    RectF mRectF;
    PointF mSize;

    //text
    String mContent;
    ArrayList<String> mTexts;
    boolean mIsCombText;
    float mFontSize;
    float mCharspace;
    float mLineHeight;

    FillSignToolHandler mToolHandler;
    PDFViewCtrl mPDFViewCtrl;
    FormObject mOldFormObj;
    FormObject mCurFormObj;
    long mJniAddr;

    public FillSignUndoItem(PDFViewCtrl pdfViewCtrl, FillSignToolHandler toolHandler) {
        mToolHandler = toolHandler;
        mPDFViewCtrl = pdfViewCtrl;
    }

    void setOldValue(FormObject obj) {
        mOldFormObj = obj;
    }

    void setCurrentValue(FormObject obj) {
        mCurFormObj = obj;
    }

    void updateJniAddr(long oldAddr, long newAddr) {
        if (mOldFormObj != null && mOldFormObj.mJniAddr == oldAddr) {
            mOldFormObj.mJniAddr = newAddr;
        }
        if (mCurFormObj != null && mCurFormObj.mJniAddr == oldAddr) {
            mCurFormObj.mJniAddr = newAddr;
        }
    }

    @Override
    public boolean undo() {
        if (mToolHandler.isEditingText()) {
            mToolHandler.endAddTextBox();
            return false;
        }
        return true;
    }

    @Override
    public boolean redo() {
        if (mToolHandler.isEditingText()) {
            mToolHandler.endAddTextBox();
            return false;
        }
        return true;
    }

}

class FillSignModifyUndoItem extends FillSignUndoItem {
    int mUndoType;
    RectF mUndoRectF;
    ArrayList<String> mUndoTexts;
    String mUndoContent;
    float mUndoFontSize;
    float mUndoCharspace;

    int mRedoType;
    RectF mRedoRectF;
    String mRedoContent;
    ArrayList<String> mRedoTexts;
    float mRedoFontSize;
    float mRedoCharspace;

    FillSignModifyUndoItem(PDFViewCtrl pdfViewCtrl, FillSignToolHandler toolHandler) {
        super(pdfViewCtrl, toolHandler);
    }

    @Override
    public boolean undo() {
        if (!super.undo())
            return false;
        if (mToolHandler.mFocusAnnot != null && mToolHandler.mFocusAnnot.mJniAddr == mOldFormObj.mJniAddr) {
            mToolHandler.focusObject(null);
        }
        mToolHandler.modifyFormObject(mCurFormObj.mPageIndex, mCurFormObj, mOldFormObj, mRotation, false, null);
        return true;
    }

    @Override
    public boolean redo() {
        if (!super.redo())
            return false;
        if (mToolHandler.mFocusAnnot != null && mToolHandler.mFocusAnnot.mJniAddr == mCurFormObj.mJniAddr) {
            mToolHandler.focusObject(null);
        }
        mToolHandler.modifyFormObject(mOldFormObj.mPageIndex, mOldFormObj, mCurFormObj, mRotation, false, null);
        return true;
    }

}

class FillSignDeleteUndoItem extends FillSignUndoItem {

    FillSignDeleteUndoItem(PDFViewCtrl pdfViewCtrl, FillSignToolHandler toolHandler) {
        super(pdfViewCtrl, toolHandler);
    }

    @Override
    public boolean undo() {
        if (!super.undo())
            return false;
        if (mOldFormObj.mTag == ToolConstants.FillSignTypeText
                || mOldFormObj.mTag == ToolConstants.FillSignTypeComboText) {
            mToolHandler.addTextFormObj(mOldFormObj, null);
        } else {
            mToolHandler.addFormObject(mOldFormObj.mTag, mOldFormObj.mPageIndex, mOldFormObj.mBBox, mRotation, mOldFormObj.mJniAddr, null);
        }
        return true;
    }

    @Override
    public boolean redo() {
        if (!super.redo())
            return false;
        mToolHandler.deleteFormObject(mOldFormObj.mPageIndex, mOldFormObj);
        return true;
    }
}

class FillSignAddUndoItem extends FillSignUndoItem {

    FillSignAddUndoItem(PDFViewCtrl pdfViewCtrl, FillSignToolHandler toolHandler) {
        super(pdfViewCtrl, toolHandler);
    }

    @Override
    public boolean undo() {
        if (!super.undo())
            return false;
        mToolHandler.deleteFormObject(mCurFormObj.mPageIndex, mCurFormObj);
        return true;
    }

    @Override
    public boolean redo() {
        if (!super.redo())
            return false;
        if (mCurFormObj.mTag == ToolConstants.FillSignTypeText
                || mCurFormObj.mTag == ToolConstants.FillSignTypeComboText) {
            mToolHandler.addTextFormObj(mCurFormObj, null);
        } else {
            mToolHandler.addFormObject(mCurFormObj.mTag, mCurFormObj.mPageIndex, mCurFormObj.mBBox, mRotation, mCurFormObj.mJniAddr, null);
        }
        return true;
    }

}