/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.form;

import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.fxcrt.PointF;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.interform.Control;
import com.foxit.sdk.pdf.interform.FillerAssistCallback;
import com.foxit.sdk.pdf.interform.TimerCallback;
import com.foxit.uiextensions.utils.AppDmUtil;
import com.foxit.uiextensions.utils.AppUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormFillerAssistImpl extends FillerAssistCallback {

    private PDFViewCtrl mPDFViewCtrl;
    protected boolean bWillClose = false;
    boolean bWillSave = false;
    private boolean isScaling = false;
    private FormFillerAnnotHandler.FillerFocusEventListener mFocusEventListener;
    private FormFillerAnnotHandler.FillerPopupMenuListener mPopupMenuListener;

    public FormFillerAssistImpl(PDFViewCtrl pdfViewCtrl, FormFillerAnnotHandler.FillerFocusEventListener focusEventListener) {
        this.mPDFViewCtrl = pdfViewCtrl;
        mFocusEventListener = focusEventListener;
    }

    public void setScaling(boolean scaling) {
        isScaling = scaling;
    }

    void reset() {
        handler.removeCallbacksAndMessages(null);
        synchronized (pendingPageRects) {
            pendingPageRects.clear();
        }
    }

    @Override
    public void focusGotOnControl(Control control, String filedValue) {
        if (mFocusEventListener != null)
            mFocusEventListener.focusGotOnControl(control, filedValue);
    }

    @Override
    public void focusLostFromControl(Control control, String filedValue) {
        if (mFocusEventListener != null)
            mFocusEventListener.focusLostFromControl(control, filedValue);
    }

    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Map<Number, List<com.foxit.sdk.common.fxcrt.RectF>> pendingPageRects = new HashMap<>();
    private Runnable refreshRunnable;

    @Override
    public void refresh(PDFPage page, com.foxit.sdk.common.fxcrt.RectF rect) {
        if (bWillClose || bWillSave || isScaling) return;

        synchronized (pendingPageRects) {
            try {
                int pageIndex = page.getIndex();
                List<com.foxit.sdk.common.fxcrt.RectF> rectList = pendingPageRects.get(pageIndex);
                if (rectList == null) {
                    rectList = new ArrayList<>();
                    pendingPageRects.put(pageIndex, rectList);
                }
                rectList.add(new com.foxit.sdk.common.fxcrt.RectF(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop()));
            }catch (PDFException ignored){
            }
        }

        if (refreshRunnable != null) {
            handler.removeCallbacks(refreshRunnable);
        }

        refreshRunnable = new Runnable() {
            @Override
            public void run() {
                Map<Number, List<com.foxit.sdk.common.fxcrt.RectF>> batch;
                synchronized (pendingPageRects) {
                    batch = new HashMap<>(pendingPageRects);
                    pendingPageRects.clear();
                }
                doBatchRefresh(batch);
            }
        };
        handler.postDelayed(refreshRunnable, 30);
    }

    private void doBatchRefresh(Map<Number, List<com.foxit.sdk.common.fxcrt.RectF>> pageRects) {
        for (Map.Entry<Number, List<com.foxit.sdk.common.fxcrt.RectF>> entry : pageRects.entrySet()) {
            int pageIndex = (int) entry.getKey();
            List<com.foxit.sdk.common.fxcrt.RectF> rects = entry.getValue();
            if (rects == null || rects.isEmpty()) {
                continue;
            }

            com.foxit.sdk.common.fxcrt.RectF totalRect = new com.foxit.sdk.common.fxcrt.RectF();
            for (int i = 0; i < rects.size(); i++) {
                totalRect.union(rects.get(i));
            }

            if (!mPDFViewCtrl.isPageVisible(pageIndex)) return;
            RectF viewRect = new RectF(0, 0, mPDFViewCtrl.getDisplayViewWidth(), mPDFViewCtrl.getDisplayViewHeight());
            RectF pdfRect = AppUtil.toRectF(totalRect);
            RectF pvRect = new RectF();
            mPDFViewCtrl.convertPdfRectToPageViewRect(pdfRect, pvRect, pageIndex);

            RectF disRect = new RectF();
            mPDFViewCtrl.convertPageViewRectToDisplayViewRect(pvRect, disRect, pageIndex);
            if (!viewRect.intersect(disRect)) return;

            pvRect.inset(-5, -5);
            mPDFViewCtrl.refresh(pageIndex, AppDmUtil.rectFToRect(pvRect));
        }
    }

    @Override
    public void release() {
    }

    @Override
    public boolean setTimerCallback(int elapse, TimerCallback timer, Integer out_timer_id) {
        return false;
    }

    @Override
    public boolean killTimer(int timer_id) {
        return false;
    }

    @Override
    public Object createPopupMenu() {
        return new Object();
    }

    @Override
    public boolean appendPopupMenuItem(Object h_popup_menu, int popup_menu_item, String default_string) {
        if (mPopupMenuListener == null) return false;
        mPopupMenuListener.appendPopupMenuItem(popup_menu_item, default_string);
        return false;
    }

    @Override
    public boolean enablePopupMenuItem(Object h_popup_menu, int popup_menu_item, boolean is_enabled) {
        if (mPopupMenuListener == null) return false;
        mPopupMenuListener.enablePopupMenuItem(popup_menu_item, is_enabled);
        return false;
    }

    @Override
    public boolean showPopupMenu(Object h_popup_menu, PointF point) {
        if (mPopupMenuListener == null) return false;
        mPopupMenuListener.showPopupMenu(point);
        return false;
    }

    @Override
    public void destroyPopupMenu(Object h_popup_menu) {
    }

    @Override
    public void setClipboardText(String text) {
        if (mPopupMenuListener == null) return;
        mPopupMenuListener.setClipboardText(text);
    }

    @Override
    public String getClipboardText() {
        if (mPopupMenuListener == null) return null;
        return mPopupMenuListener.getClipboardText();
    }

    @Override
    public void reportInvalidValue(String form_field_name, String invalid_value) {
    }

//    @Override //todo merge code
//    public void executeAction(PDFPage page, Action action) {
//        // MOBRD-7847
//        // 需要处理除FPD_ActionType:Hide/Named/SubmitForm/ResetForm/URI 之外的类型
//        LinkModule linkModule = (LinkModule) ((UIExtensionsManager)mPDFViewCtrl.getUIExtensionsManager()).getModuleByName(Module.MODULE_NAME_LINK);
//        if (linkModule != null) {
//            DocumentManager documentManager = ((UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager()).getDocumentManager();
//            if (documentManager.getCurrentAnnot() != null) {
//                documentManager.setCurrentAnnot(null, false);
//            }
//            linkModule.jumpToActionDest(action);
//        }
//    }

    public void setPopupMenuListener(FormFillerAnnotHandler.FillerPopupMenuListener listener) {
        mPopupMenuListener = listener;
    }

    public void destroy(){
        mFocusEventListener = null;
        mPopupMenuListener = null;
    }
}
