/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink;

import com.foxit.uiextensions.annots.common.EditAnnotEvent;

import java.util.ArrayList;

public class EraserEvent extends EditAnnotEvent {
    private ArrayList<EditAnnotEvent> mEventList;

    public EraserEvent(ArrayList<EditAnnotEvent> events) {
        mEventList = events;
    }

    @Override
    protected boolean execute() {
        if (mEventList == null || mEventList.size() == 0) return false;

        for (EditAnnotEvent event : mEventList) {
            if (event.mType == EVENTTYPE_ADD) {
                event.add();
            } else if (event.mType == EVENTTYPE_MODIFY) {
                event.modify();
            } else if (event.mType == EVENTTYPE_DELETE) {
                event.delete();
            }
        }
        return true;
    }

    @Override
    public boolean add() {
        return false;
    }

    @Override
    public boolean modify() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }
}
