/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink;


import android.graphics.PointF;

class PSIData {
    PointF pointF;
    int path_type;
    float pressure;

    public PSIData() {
        pointF = new PointF();
        path_type = 0;
        pressure = 0;
    }

    public PSIData(PointF pointF, float pressure, int path_type) {
        this.pointF = pointF;
        this.path_type = path_type;
        this.pressure = pressure;
    }

    public PSIData(PSIData psiData) {
        this.pointF = new PointF(psiData.pointF.x, psiData.pointF.y);
        this.pressure = psiData.pressure;
        this.path_type = psiData.path_type;
    }
}
