/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink.ocr;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.controls.dialog.UILoadingRing;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;

import java.util.List;


public class InkLanguagesAdapter extends SuperAdapter<ModelLanguageContainer> {
    private Context mContext;
    private UIExtensionsManager mUIExtensionsManager;
    private OnItemClickCallback mOnItemClickCallback;
    private List<ModelLanguageContainer> mLanguagesList;
    public InkLanguagesAdapter(Context context, UIExtensionsManager uIExtensionsManager) {
        super(context);
        mContext = context;
        mUIExtensionsManager = uIExtensionsManager;
    }

    void setLanguagesList(List<ModelLanguageContainer> languagesList) {
        mLanguagesList = languagesList;
    }



    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public ModelLanguageContainer getDataItem(int position) {
        return mLanguagesList.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        return new CurrentLanguagesSupportedHolder(LayoutInflater.from(getContext()).inflate(R.layout.ink_languages_item, parent, false));
    }

    @Override
    public int getItemCount() {
        return mLanguagesList.size();
    }

    class CurrentLanguagesSupportedHolder extends SuperViewHolder {
        private LinearLayout mLanguagesLl;
        private ImageView mLanguagesSelectIv;

        private ImageView mLanguagesDelete;
        private TextView mLanguagesTv;
        private TextView mDownLoadTv;
        private UILoadingRing mDownRing;

        public CurrentLanguagesSupportedHolder(View itemView) {
            super(itemView);
            mLanguagesLl = itemView.findViewById(R.id.ink_languages_item_ll);
            mLanguagesTv = itemView.findViewById(R.id.ink_languages_item_text);
            mLanguagesSelectIv = itemView.findViewById(R.id.ink_languages_item_iv);
            mDownLoadTv = itemView.findViewById(R.id.ink_languages_item_download);
            mLanguagesDelete = itemView.findViewById(R.id.ink_languages_item_delete);
            mDownRing = itemView.findViewById(R.id.ink_languages_item_ring);
            ThemeUtil.setTintList(mLanguagesSelectIv, ThemeUtil.getItemIconColor(mContext));
            ThemeUtil.setTintList(mLanguagesDelete, ThemeUtil.getEnableIconColor(mContext));
            mLanguagesLl.setOnClickListener(this);
            mLanguagesSelectIv.setOnClickListener(this);
            mDownLoadTv.setOnClickListener(this);
            mLanguagesDelete.setOnClickListener(this);

        }

        @Override
        public void bind(BaseBean data, int position) {
            ModelLanguageContainer languagesBean= (ModelLanguageContainer) data;
            mLanguagesTv.setText(AppResource.getString(mContext,languagesBean.getStrId()));
            if(languagesBean.getDownloadStatus() == ModelLanguageContainer.downloaded){
                mDownLoadTv.setVisibility(View.GONE);
                mDownRing.setVisibility(View.GONE);
                if(languagesBean.isSelector()){
                    mLanguagesSelectIv.setVisibility(View.VISIBLE);
                    mLanguagesDelete.setVisibility(View.GONE);
                }else{
                    mLanguagesSelectIv.setVisibility(View.GONE);
                    mLanguagesDelete.setVisibility(View.VISIBLE);

                }
            }else if(languagesBean.getDownloadStatus() == ModelLanguageContainer.downLoad){
                mDownLoadTv.setVisibility(View.VISIBLE);
                mLanguagesSelectIv.setVisibility(View.GONE);
                mLanguagesDelete.setVisibility(View.GONE);
                mDownRing.setVisibility(View.GONE);
                mDownLoadTv.setText(AppResource.getString(mContext,R.string.ocr_ink_download));
            }else if(languagesBean.getDownloadStatus() == ModelLanguageContainer.downLoading){
                mDownLoadTv.setVisibility(View.GONE);
                mLanguagesSelectIv.setVisibility(View.GONE);
                mLanguagesDelete.setVisibility(View.GONE);
                mDownRing.setVisibility(View.VISIBLE);
            }
        }

        @Override
        public void onClick(View v) {
            int id = v.getId();
            int position = getAdapterPosition();
            ModelLanguageContainer item = mLanguagesList.get(position);
            if(id == R.id.ink_languages_item_ll){
                if(item.getDownloadStatus() == ModelLanguageContainer.downloaded){
                    mOnItemClickCallback.onItemClick(position,item);
                }
            }else if(id == R.id.ink_languages_item_download){
                mOnItemClickCallback.onItemDownLoadClick(position,item);
            }else if(id == R.id.ink_languages_item_delete){
                mOnItemClickCallback.onItemDeleteClick(position,item);
            }
        }
    }

    void setOnItemClickCallback(OnItemClickCallback callback) {
        mOnItemClickCallback = callback;
    }

    interface OnItemClickCallback {
        void onItemClick(int position, ModelLanguageContainer item);
        void onItemDownLoadClick(int position, ModelLanguageContainer item);

        void onItemDeleteClick(int position, ModelLanguageContainer item);
    }
}
