/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink.ocr;


import com.foxit.uiextensions.R;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;

import java.util.Locale;

import androidx.annotation.Nullable;


public class ModelLanguageContainer extends BaseBean {

    public static int downLoad = 0;
    public static int downloaded = 1;
    public static int downLoading = 2;
    private int strId;
    @Nullable
    private String languageTag;

    private int downloadStatus = 0;
    private boolean selector;

    ModelLanguageContainer(@Nullable String languageTag) {
        this.languageTag = languageTag;
    }

    ModelLanguageContainer(int strId, @Nullable String languageTag) {
        this.strId = strId;
        this.languageTag = languageTag;
    }

    public int getStrId() {
        return strId;
    }

    public void setStrId(int strId) {
        this.strId = strId;
    }

    @Nullable
    public String getLanguageTag() {
        return languageTag;
    }

    public void setLanguageTag(@Nullable String languageTag) {
        this.languageTag = languageTag;
    }

    public int getDownloadStatus() {
        return downloadStatus;
    }

    public void setDownloadStatus(int downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public boolean isSelector() {
        return selector;
    }

    public void setSelector(boolean selector) {
        this.selector = selector;
    }


    public static String getCurrentRegionalLanguage() {
        String currentLanguage = "";
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        switch (language) {
            case "en":
                currentLanguage = "en-US";
                break;
            case "de":
                currentLanguage = "de-DE";
                break;
            case "pt":
                currentLanguage = "pt-BR";
                break;
            case "it":
                currentLanguage = "it-IT";
                break;
            case "fr":
                currentLanguage = "fr-FR";
                break;
            case "ko":
                currentLanguage = "ko";
                break;
            case "zh":
                if("CN".equalsIgnoreCase(country)) {
                    currentLanguage = "zh-Hani-CN";
                }else {
                    currentLanguage = "zh-Hani-TW";
                }
                break;
            case "es":
                currentLanguage = "es";
                break;
            case "ru":
                currentLanguage = "ru";
                break;
            case "nl":
                currentLanguage = "nl-NL";
                break;
            case "ja":
                currentLanguage = "ja";
                break;
            default:
                currentLanguage = "en-US";
                break;
        }
        return currentLanguage;
    }

    public static int getLanguagesId(String language){
        int strId = 0;
        switch (language){
            case "en-US":
                strId = R.string.ocr_ink_english;
                break;
            case "de-DE":
                strId = R.string.ocr_ink_german;
                break;
            case "pt-BR":
                strId = R.string.ocr_ink_portuguese;
                break;
            case "it-IT":
                strId = R.string.ocr_ink_italian;
                break;
            case "fr-FR":
                strId = R.string.ocr_ink_french;
                break;
            case "ko":
                strId = R.string.ocr_ink_korean;
                break;
            case "zh-Hani-CN":
                strId = R.string.ocr_ink_simplified_chinese;
                break;
            case "zh-Hani-TW":
                strId = R.string.ocr_ink_tranditional_chinese;
                break;
            case "es":
                strId = R.string.ocr_ink_spanish;
                break;
            case "ru":
                strId = R.string.ocr_ink_russian;
                break;
            case "nl-NL":
                strId = R.string.ocr_ink_dutch;
                break;
            case "ja":
                strId = R.string.ocr_ink_japanese;
                break;
            default:
                strId = R.string.ocr_ink_english;
                break;
        }

        return strId;
    }

}
