/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.link;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Link;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.AnnotUndoItem;
import com.foxit.uiextensions.annots.common.EditAnnotEvent;
import com.foxit.uiextensions.utils.AppAnnotUtil;
import com.foxit.uiextensions.utils.AppDmUtil;
import com.foxit.uiextensions.utils.AppUtil;

public class LinkEvent extends EditAnnotEvent {

    public LinkEvent(int eventType, LinkUndoItem undoItem, Link link, PDFViewCtrl pdfViewCtrl) {
        mType = eventType;
        mUndoItem = undoItem;
        mAnnot = link;
        mPdfViewCtrl = pdfViewCtrl;
    }

    @Override
    public boolean add() {
        boolean result = false;
        try {
            result = addAnnot(mAnnot, mUndoItem);
            if (result)
                ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return result;
        } catch (PDFException e) {
            if (e.getLastError() == Constants.e_ErrOutOfMemory) {
                mPdfViewCtrl.recoverForOOM();
            }
        }
        return result;
    }

    @Override
    public boolean modify() {
        if (mAnnot == null || !(mAnnot instanceof Link)) {
            return false;
        }

        try {
            Link annot = (Link) mAnnot;
            LinkModifyUndoItem undoItem = (LinkModifyUndoItem) mUndoItem;
            if (mUndoItem.mBBox != null)
                annot.move(AppUtil.toFxRectF(mUndoItem.mBBox));
            annot.setModifiedDateTime(AppDmUtil.currentDateToDocumentDate());
            if (undoItem.mBorderInfo != null)
                annot.setBorderInfo(undoItem.mBorderInfo);
            annot.resetAppearanceStream();
            if (undoItem.mAction != null && !undoItem.mAction.isEmpty())
                annot.setAction(undoItem.mAction);
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean delete() {
        boolean result = false;
        try {
            result = removeAnnot(mAnnot);
            if (result)
                ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return result;
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean removeAnnot(Annot annot) throws PDFException {
        if (!(annot instanceof Link)) {
            return false;
        }
        PDFPage page = annot.getPage();
        return page.removeAnnot(annot);
    }

    private boolean addAnnot(Annot annot, AnnotUndoItem undo) throws PDFException {
        if (!(annot instanceof Link)) {
            return false;
        }
        LinkUndoItem undoItem = (LinkUndoItem) undo;
        Link link = (Link) annot;
        if (undoItem.mPDFDict != null) {
            boolean reset = AppAnnotUtil.resetPDFDict(link, undoItem.mPDFDict);
            if (reset) {
                return true;
            }
        }
        if (undoItem.mModifiedDate != null && AppDmUtil.isValidDateTime(undoItem.mModifiedDate)) {
            link.setModifiedDateTime(undoItem.mModifiedDate);
        }
        link.setUniqueID(undoItem.mNM);
        link.resetAppearanceStream();
        return true;
    }
}
