/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.multimedia;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;

import java.util.ArrayList;
import java.util.List;

public class PhoneStateBroadCastReceiver extends BroadcastReceiver {
    public interface IPhoneStateListener {
        void onOutGoingCall();
        void onIncomingCall();
        void onCallIdle();
    }
    private static List<IPhoneStateListener> mListeners = new ArrayList<>();
    public void registerListener(IPhoneStateListener listener) {
        if (!mListeners.contains(listener)) {
            mListeners.add(listener);
        }
    }

    public void unregisterListener(IPhoneStateListener listener) {
        if (mListeners.contains(listener)) {
            mListeners.remove(listener);
        }
    }

    public PhoneStateBroadCastReceiver(){}

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent != null
                && intent.getAction() != null
                && intent.getAction().equals(Intent.ACTION_NEW_OUTGOING_CALL)) {

            for(IPhoneStateListener listener : mListeners) {
                listener.onOutGoingCall();
            }

        } else {
            TelephonyManager tManager = (TelephonyManager) context.getSystemService(Service.TELEPHONY_SERVICE);
            switch (tManager.getCallState()) {
                case TelephonyManager.CALL_STATE_RINGING:
                case TelephonyManager.CALL_STATE_OFFHOOK:
                   for (IPhoneStateListener listener : mListeners) {
                        listener.onIncomingCall();
                    }
                    break;
                case TelephonyManager.CALL_STATE_IDLE:
                    for (IPhoneStateListener listener : mListeners) {
                        listener.onCallIdle();
                    }
                    break;
                default:
                    break;
            }
        }
    }
}
