/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.multimedia.screen.multimedia;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.Rendition;
import com.foxit.sdk.pdf.actions.Action;
import com.foxit.sdk.pdf.actions.AdditionalAction;
import com.foxit.sdk.pdf.actions.RenditionAction;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.RichMedia;
import com.foxit.sdk.pdf.annots.Screen;
import com.foxit.uiextensions.config.JsonConstants;
import com.foxit.uiextensions.utils.AppAnnotUtil;

import java.util.HashMap;

public class MultimediaManager {
    private static MultimediaManager instance;

    private HashMap<String, String> mTypeMap = new HashMap<>();

    private MultimediaManager() {
    }

    public static MultimediaManager getInstance() {
        if (instance == null)
            instance = new MultimediaManager();
        return instance;
    }

    public String getTypeString(Annot annot) {
        if (annot == null || annot.isEmpty())
            return "Unknown";
        String nm = AppAnnotUtil.getAnnotUniqueID(annot);
        if (annot instanceof RichMedia){
            mTypeMap.put(nm, JsonConstants.TYPE_RICH_MEDIA);
            return mTypeMap.get(nm);
        }
        try {
            Screen screen = (Screen) annot;

            if (mTypeMap.get(nm) != null)
                return mTypeMap.get(nm);

            Action action = screen.getAction();
            if (action.isEmpty()) {
                String type = JsonConstants.TYPE_SCREEN_IMAGE;
                AdditionalAction additionalAction = new AdditionalAction(screen);
                if (!additionalAction.isEmpty() && !additionalAction.getAction(AdditionalAction.e_TriggerAnnotMouseButtonPressed).isEmpty()){
                    type = JsonConstants.TYPE_SCREEN_URL;
                }
                mTypeMap.put(nm, type);
                return type;
            } else {
                if (Action.e_TypeRendition != action.getType()) {
                    mTypeMap.put(nm, JsonConstants.TYPE_SCREEN_IMAGE);
                    return JsonConstants.TYPE_SCREEN_IMAGE;
                }

                // Note: the action have sub action,but at the moment we only judge the first level.
                RenditionAction renditionAction = new RenditionAction(action);
                if (renditionAction.isEmpty() || renditionAction.getRenditionCount() == 0) {
                    mTypeMap.put(nm, JsonConstants.TYPE_SCREEN_IMAGE);
                    return JsonConstants.TYPE_SCREEN_IMAGE;
                } else {
                    Rendition rendition = renditionAction.getRendition(0);
                    if (rendition.isEmpty()) {
                        mTypeMap.put(nm, JsonConstants.TYPE_SCREEN_IMAGE);
                        return JsonConstants.TYPE_SCREEN_IMAGE;
                    } else {
                        String mimeType = rendition.getMediaClipContentType();
                        if (mimeType == null || mimeType.isEmpty()) {
                            mTypeMap.put(nm, JsonConstants.TYPE_SCREEN_IMAGE);
                            return JsonConstants.TYPE_SCREEN_IMAGE;
                        } else if (mimeType.toLowerCase().contains("audio")) {
                            mTypeMap.put(nm, JsonConstants.TYPE_AUDIO);
                            return JsonConstants.TYPE_AUDIO;
                        } else if (mimeType.toLowerCase().contains("video")
                                || mimeType.contains("application/x-shockwave-flash")
                                || mimeType.contains("application/futuresplash")) {
                            mTypeMap.put(nm, JsonConstants.TYPE_VIDEO);
                            return JsonConstants.TYPE_VIDEO;
                        } else {
                            mTypeMap.put(nm, JsonConstants.TYPE_SCREEN_IMAGE);
                            return JsonConstants.TYPE_SCREEN_IMAGE;
                        }
                    }
                }
            }
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return "Unknown";
    }

    public void clear() {
        mTypeMap.clear();
    }
}
