/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.multiselect;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.view.ViewGroup;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.uiextensions.AbstractUndo;
import com.foxit.uiextensions.DocumentManager;
import com.foxit.uiextensions.IUndoItem;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.ToolHandler;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.event.DocEventListener;

public class MultiSelectModule implements Module {
    private Context mContext;
    private ViewGroup mParent;
    private PDFViewCtrl mPdfViewCtrl;
    private PDFViewCtrl.UIExtensionsManager mUiExtensionsManager;

    private MultiSelectToolHandler mMSTool;
    private MultiSelectAnnotHandler mMSAnnotHander;

    public MultiSelectModule(Context context, ViewGroup parent, PDFViewCtrl pdfViewCtrl, PDFViewCtrl.UIExtensionsManager uiExtensionsManager) {
        mContext = context;
        mParent = parent;
        mPdfViewCtrl = pdfViewCtrl;
        mUiExtensionsManager = uiExtensionsManager;
    }

    @Override
    public String getName() {
        return MODULE_NAME_SELECT_ANNOTATIONS;
    }

    @Override
    public boolean loadModule() {
        mMSTool = new MultiSelectToolHandler(mContext, mPdfViewCtrl);
        mMSAnnotHander = new MultiSelectAnnotHandler(mContext, mPdfViewCtrl);
        if (mUiExtensionsManager != null && mUiExtensionsManager instanceof UIExtensionsManager) {
            ((UIExtensionsManager) mUiExtensionsManager).registerModule(this);
            ((UIExtensionsManager) mUiExtensionsManager).registerToolHandler(mMSTool);
            ((UIExtensionsManager) mUiExtensionsManager).registerAnnotHandler(mMSAnnotHander);
            ((UIExtensionsManager) mUiExtensionsManager).registerMenuEventListener(mMenuEventListener);
            ((UIExtensionsManager) mUiExtensionsManager).registerConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).getDocumentManager().registerUndoEventListener(mUndoEventListener);
        }
        GroupManager.getInstance().setLoadGroupModule(true);
        mPdfViewCtrl.registerDocEventListener(mDocEventListener);
        mPdfViewCtrl.registerDrawEventListener(mDrawEventListener);
        return true;
    }

    @Override
    public boolean unloadModule() {
        if (mUiExtensionsManager != null && mUiExtensionsManager instanceof UIExtensionsManager) {
            ((UIExtensionsManager) mUiExtensionsManager).unregisterToolHandler(mMSTool);
            ((UIExtensionsManager) mUiExtensionsManager).unregisterAnnotHandler(mMSAnnotHander);
            ((UIExtensionsManager) mUiExtensionsManager).unregisterMenuEventListener(mMenuEventListener);
            ((UIExtensionsManager) mUiExtensionsManager).unregisterConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).getDocumentManager().unregisterUndoEventListener(mUndoEventListener);
        }
        GroupManager.getInstance().setLoadGroupModule(false);
        mPdfViewCtrl.unregisterDocEventListener(mDocEventListener);
        mPdfViewCtrl.unregisterDrawEventListener(mDrawEventListener);
        return true;
    }

    private final PDFViewCtrl.IDrawEventListener mDrawEventListener = new PDFViewCtrl.IDrawEventListener() {

        @Override
        public void onDraw(int pageIndex, Canvas canvas) {
            if (((UIExtensionsManager) mUiExtensionsManager).getCurrentToolHandler() == mMSTool) {
                mMSTool.onDrawForControls(canvas);
            } else if (((UIExtensionsManager) mUiExtensionsManager).getCurrentAnnotHandler() == mMSAnnotHander) {
                mMSAnnotHander.onDrawForControls(canvas);
            }
        }
    };

    private final PDFViewCtrl.IDocEventListener mDocEventListener = new DocEventListener() {

        @Override
        public void onDocClosed(PDFDoc document, int errCode) {
            GroupManager.getInstance().clear();
        }

    };

    private final UIExtensionsManager.MenuEventListener mMenuEventListener = new UIExtensionsManager.MenuEventListener() {
        @Override
        public void onTriggerDismissMenu() {
            if (((UIExtensionsManager) mUiExtensionsManager).getCurrentToolHandler() == mMSTool)
                ((UIExtensionsManager) mUiExtensionsManager).setCurrentToolHandler(null);
        }
    };

    private final UIExtensionsManager.ConfigurationChangedListener mConfigurationChangedListener = new UIExtensionsManager.ConfigurationChangedListener() {
        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            if (((UIExtensionsManager) mUiExtensionsManager).getCurrentToolHandler() == mMSTool) {
                mMSTool.onConfigurationChanged(newConfig);
            } else if (((UIExtensionsManager) mUiExtensionsManager).getCurrentAnnotHandler() == mMSAnnotHander) {
                mMSAnnotHander.onConfigurationChanged(newConfig);
            }
        }
    };

    private final AbstractUndo.IUndoEventListener mUndoEventListener = new AbstractUndo.IUndoEventListener() {
        @Override
        public void itemWillAdd(DocumentManager dm, IUndoItem item) {
        }

        @Override
        public void itemAdded(DocumentManager dm, IUndoItem item) {
        }

        @Override
        public void itemWillRemoved(DocumentManager dm, IUndoItem item) {
        }

        @Override
        public void itemRemoved(DocumentManager dm, IUndoItem item) {
        }

        @Override
        public void willUndo(DocumentManager dm, IUndoItem item) {
            UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mUiExtensionsManager;
            if (!(item instanceof MultiSelectUndoItem)
                    && uiExtensionsManager.getCurrentToolHandler() == mMSTool) {
                mMSTool.reset();
            }
        }

        @Override
        public void undoFinished(DocumentManager dm, IUndoItem item) {
        }

        @Override
        public void willRedo(DocumentManager dm, IUndoItem item) {
            UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mUiExtensionsManager;
            if (!(item instanceof MultiSelectUndoItem)
                    && uiExtensionsManager.getCurrentToolHandler() == mMSTool) {
                mMSTool.reset();
            }
        }

        @Override
        public void redoFinished(DocumentManager dm, IUndoItem item) {
        }

        @Override
        public void willClearUndo(DocumentManager dm) {
        }

        @Override
        public void clearUndoFinished(DocumentManager dm) {
        }
    };

    public ToolHandler getToolHandler() {
        return mMSTool;
    }

}
