/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.stamp;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Environment;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.addon.conversion.Convert;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.stamp.adapter.CommonStampAdapter;
import com.foxit.uiextensions.annots.stamp.customstamp.ImageStampBean;
import com.foxit.uiextensions.annots.stamp.customstamp.TextStampBean;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppFileUtil;
import com.foxit.uiextensions.utils.AppSharedPreferences;
import com.foxit.uiextensions.utils.AppUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class StampUtil {

    public static int getStampTypeByName(String name) {
        if (name == null) return -1;
        if (name.equals("Approved")) return 0;
        if (name.equals("Completed")) return 1;
        if (name.equals("Confidential")) return 2;
        if (name.equals("Draft")) return 3;
        if (name.equals("Emergency")) return 4;
        if (name.equals("Expired")) return 5;
        if (name.equals("Final")) return 6;
        if (name.equals("Received")) return 7;
        if (name.equals("Reviewed")) return 8;
        if (name.equals("Revised")) return 9;
        if (name.equals("Verified")) return 10;
        if (name.equals("Void")) return 11;
        if (name.equals("Accepted")) return 12;
        if (name.equals("Initial")) return 13;
        if (name.equals("Rejected")) return 14;
        if (name.equals("Sign Here")) return 15;
        if (name.equals("Witness")) return 16;
        if (name.equals("DynaApproved")) return 17;
        if (name.equals("DynaConfidential")) return 18;
        if (name.equals("DynaReceived")) return 19;
        if (name.equals("DynaReviewed")) return 20;
        if (name.equals("DynaRevised")) return 21;
        return -1;
    }

    public static String getStampNameByType(int type) {
        if (type == 0) return "Approved";
        if (type == 1) return "Completed";
        if (type == 2) return "Confidential";
        if (type == 3) return "Draft";
        if (type == 4) return "Emergency";
        if (type == 5) return "Expired";
        if (type == 6) return "Final";
        if (type == 7) return "Received";
        if (type == 8) return "Reviewed";
        if (type == 9) return "Revised";
        if (type == 10) return "Verified";
        if (type == 11) return "Void";
        if (type == 12) return "Accepted";
        if (type == 13) return "Initial";
        if (type == 14) return "Rejected";
        if (type == 15) return "Sign Here";
        if (type == 16) return "Witness";
        if (type == 17) return "DynaApproved";
        if (type == 18) return "DynaConfidential";
        if (type == 19) return "DynaReceived";
        if (type == 20) return "DynaReviewed";
        if (type == 21) return "DynaRevised";
        if (type == StampConstants.CUSTOM_TEXT_STAMP) return "TextStamp";
        if (type == StampConstants.CUSTOM_IMAGE_STAMP) return "ImageStamp";
        return null;
    }

    private static Integer[] mStampIds = {
            R.drawable._feature_annot_stamp_style0,
            R.drawable._feature_annot_stamp_style1,
            R.drawable._feature_annot_stamp_style2,
            R.drawable._feature_annot_stamp_style3,
            R.drawable._feature_annot_stamp_style4,
            R.drawable._feature_annot_stamp_style5,
            R.drawable._feature_annot_stamp_style6,
            R.drawable._feature_annot_stamp_style7,
            R.drawable._feature_annot_stamp_style8,
            R.drawable._feature_annot_stamp_style9,
            R.drawable._feature_annot_stamp_style10,
            R.drawable._feature_annot_stamp_style11,
            R.drawable._feature_annot_stamp_style12,
            R.drawable._feature_annot_stamp_style13,
            R.drawable._feature_annot_stamp_style14,
            R.drawable._feature_annot_stamp_style15,
            R.drawable._feature_annot_stamp_style16,
            R.drawable._feature_annot_stamp_style17,
            R.drawable._feature_annot_stamp_style18,
            R.drawable._feature_annot_stamp_style19,
            R.drawable._feature_annot_stamp_style20,
            R.drawable._feature_annot_stamp_style21,
    };

    public static int getStampIconByType(int type) {
        return mStampIds[type];
    }

    public static int getStampIconThumbnail(int type) {
        if (type == 0) return R.drawable.stamp_standard_approved;
        if (type == 1) return R.drawable.stamp_standard_completed;
        if (type == 2) return R.drawable.stamp_standard_confidential;
        if (type == 3) return R.drawable.stamp_standard_draft;
        if (type == 4) return R.drawable.stamp_standard_emergency;
        if (type == 5) return R.drawable.stamp_standard_expired;
        if (type == 6) return R.drawable.stamp_standard_final;
        if (type == 7) return R.drawable.stamp_standard_received;
        if (type == 8) return R.drawable.stamp_standard_reviewed;
        if (type == 9) return R.drawable.stamp_standard_revised;
        if (type == 10) return R.drawable.stamp_standard_verified;
        if (type == 11) return R.drawable.stamp_standard_void;
        if (type == 12) return R.drawable.stamp_sign_accepted;
        if (type == 13) return R.drawable.stamp_sign_initial;
        if (type == 14) return R.drawable.stamp_sign_rejected;
        if (type == 15) return R.drawable.stamp_sign_signhere;
        if (type == 16) return R.drawable.stamp_sign_witness;
        if (type == 17) return R.drawable.stamp_dynamic_approved;
        if (type == 18) return R.drawable.stamp_dynamic_confidential;
        if (type == 19) return R.drawable.stamp_dynamic_received;
        if (type == 20) return R.drawable.stamp_dynamic_reviewed;
        if (type == 21) return R.drawable.stamp_dynamic_revised;
        if (type == StampConstants.CUSTOM_TEXT_STAMP) return R.drawable.stamp_custom_text;
        if (type == StampConstants.CUSTOM_IMAGE_STAMP) return R.drawable.stamp_custom_image;
        return -0;
    }

    public static int getStampTypeByNameForReview(String name, String stream) {
        if (name.equals("Approved") || name.equals("DynaApproved")) {
            if (stream.equals("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")) {
                return 0;
            } else {
                return 17;
            }
        }
        if (name.equals("Completed")) return 1;
        if (name.equals("Confidential") || name.equals("DynaConfidential")) {
            if (stream.equals("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")) {
                return 2;
            } else {
                return 18;
            }

        }
        if (name.equals("Draft")) return 3;
        if (name.equals("Emergency")) return 4;
        if (name.equals("Expired")) return 5;
        if (name.equals("Final")) return 6;
        if (name.equals("Received") || name.equals("DynaReceived")) {
            if (stream.equals("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")) {
                return 7;
            } else {
                return 19;
            }
        }

        if (name.equals("Reviewed") || name.equals("DynaReviewed")) {
            if (stream.equals("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")) {
                return 8;
            } else {
                return 20;
            }
        }
        if (name.equals("Revised") || name.equals("DynaRevised")) {
            if (stream.equals("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")) {
                return 9;
            } else {
                return 21;
            }
        }
        if (name.equals("Verified")) return 10;
        if (name.equals("Void")) return 11;
        if (name.equals("Accepted")) return 12;
        if (name.equals("Initial")) return 13;
        if (name.equals("Rejected")) return 14;
        if (name.equals("Sign Here")) return 15;
        if (name.equals("Witness")) return 16;
        return 3;
    }

    static List<CommonStampAdapter.CommonStampItemBean> getStandardStampBeans() {
        List<CommonStampAdapter.CommonStampItemBean> beans = new ArrayList<>();
        for (int i = 0; i < 12; i++) {
            CommonStampAdapter.CommonStampItemBean bean = new CommonStampAdapter.CommonStampItemBean(i, mStampIds[i]);
            beans.add(bean);
        }
        return beans;
    }

    static List<CommonStampAdapter.CommonStampItemBean> getSignStampBeans() {
        List<CommonStampAdapter.CommonStampItemBean> beans = new ArrayList<>();
        for (int i = 0; i < 5; i++) {
            int type = i + 12;
            CommonStampAdapter.CommonStampItemBean bean = new CommonStampAdapter.CommonStampItemBean(type, mStampIds[type]);
            beans.add(bean);
        }
        return beans;
    }


    static List<TextStampBean> getDynamicStampBeans() {
        List<TextStampBean> beans = new ArrayList<>();
        for (int i = 0; i < StampConstants.Dynamic_Stamp_Names.length; i++) {
            String name = StampConstants.Dynamic_Stamp_Names[i];
            TextStampBean stampBean = new TextStampBean();
            stampBean.mText = name;
            stampBean.mColor = 0xff4ea884;
            stampBean.mCreateTime = System.currentTimeMillis();
            beans.add(stampBean);
        }
        return beans;
    }

    public static String formatTime(long timeMillis) {
        try {
            DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            return dateFormat.format(new Date(timeMillis));
        } catch (Exception ignored) {
        }
        return "";
    }

    public static String formatDate(long timeMillis) {
        try {
            DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.getDefault());
            return dateFormat.format(new Date(timeMillis));
        } catch (Exception ignored) {
        }
        return "";
    }

    public static Bitmap createBitmapFromPath(String path, int inSampleSize) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = inSampleSize;
            Bitmap originBitmap = BitmapFactory.decodeFile(path, options);

            int pictureRotate = AppFileUtil.readPictureDegree(path);
            if (pictureRotate != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate(pictureRotate);
                originBitmap = Bitmap.createBitmap(originBitmap, 0, 0,
                        originBitmap.getWidth(), originBitmap.getHeight(), matrix, true);
            }
            return originBitmap;
        } catch (Exception ignored) {
        }
        return null;
    }

    public static Bitmap getThumbnailBitmap(Context context, String path) {
        File file = new File(path);
        if (file.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(path, options);
            int width = options.outWidth;
            int height = options.outHeight;
            int targetWidth = AppDisplay.dp2px(160);
            int targetHeight = AppDisplay.dp2px(75);
            int widthRatio = (int) Math.ceil(width / (float) targetWidth);
            int heightRatio = (int) Math.ceil(height / (float) targetHeight);
            if (widthRatio > 1 || heightRatio > 1) {
                options.inSampleSize = Math.max(widthRatio, heightRatio);
            }
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile(path, options);
        } else {
            return BitmapFactory.decodeResource(context.getResources(), R.drawable.custom_stamp_image_empty_icon);
        }
    }

    public static int[] getImageInfo(String imagePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(imagePath, options);
        int w = options.outWidth;
        int h = options.outHeight;
        return new int[]{w, h};
    }

    public static List<TextStampBean> getTextStamps(Context context) {
        String stampStr = AppSharedPreferences.getInstance(context).getString(StampConstants.SP_NAME,
                StampConstants.SP_KEY_TEXT_STAMPS, "");
        List<TextStampBean> stampBeans = new ArrayList<>();
        if (!AppUtil.isEmpty(stampStr)) {
            try {
                JSONArray jsonArray = new JSONArray(stampStr);
                for (int i = 0; i < jsonArray.length(); i++) {
                    TextStampBean stampBean = new TextStampBean();
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    stampBean.mText = jsonObject.optString("text");
                    stampBean.mCreateTime = jsonObject.optLong("createTime");
                    stampBean.mModifiedTime = jsonObject.optLong("modifiedTime");
                    stampBean.mColor = jsonObject.optInt("color", 0xffcd4d32);
                    stampBean.mShowAuthor = jsonObject.optBoolean("showAuthor", true);
                    stampBean.mShowDate = jsonObject.optBoolean("showDate", true);
                    stampBean.mShowTime = jsonObject.optBoolean("showTime", true);
                    stampBeans.add(stampBean);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stampBeans;
    }

    public static List<ImageStampBean> getImageStamps(Context context) {
        String stampStr = AppSharedPreferences.getInstance(context).getString(StampConstants.SP_NAME,
                StampConstants.SP_KEY_IMAGE_STAMPS, "");
        List<ImageStampBean> stampBeans = new ArrayList<>();
        if (!AppUtil.isEmpty(stampStr)) {
            try {
                JSONArray jsonArray = new JSONArray(stampStr);
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String cachePath = jsonObject.optString("cacheFile");
                    if (!AppUtil.isEmpty(cachePath)) {
                        File file = new File(cachePath);
                        if (file.exists()) {
                            ImageStampBean stampBean = new ImageStampBean();
                            stampBean.mOpacity = jsonObject.optInt("opacity", 100);
                            stampBean.mCreateTime = jsonObject.optLong("createTime");
                            stampBean.mModifiedTime = jsonObject.optLong("modifiedTime");
                            stampBean.mCacheFile = cachePath;
                            stampBean.mWidth = jsonObject.optInt("width");
                            stampBean.mHeight = jsonObject.optInt("height");
                            stampBeans.add(stampBean);

                            String cachePDFPath = AppFileUtil.replaceFileExtension(cachePath, ".pdf");
                            File cachePDF = new File(cachePDFPath);
                            if (!cachePDF.exists()) {
                                convertImageToPDF(cachePath, stampBean.mOpacity);
                            }
                            PDFDoc doc = new PDFDoc(cachePDFPath);
                            int errorCode = doc.load(null);
                            if (errorCode == Constants.e_ErrSuccess) {
                                PDFPage page = doc.getPage(0);
                                stampBean.mWidth = (int) page.getWidth();
                                stampBean.mHeight = (int) page.getHeight();
                                page.delete();
                                doc.delete();
                            }
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stampBeans;
    }

    public static void saveTextStamps(Context context, List<TextStampBean> stamps) {
        if (stamps == null || stamps.size() == 0) return;

        JSONArray jsonArray = new JSONArray();
        try {
            for (TextStampBean stampBean : stamps) {
                JSONObject object = new JSONObject();
                object.put("text", stampBean.mText);
                object.put("createTime", stampBean.mCreateTime);
                object.put("modifiedTime", stampBean.mModifiedTime);
                object.put("color", stampBean.mColor);
                object.put("showAuthor", stampBean.mShowAuthor);
                object.put("showDate", stampBean.mShowDate);
                object.put("showTime", stampBean.mShowTime);
                jsonArray.put(object);
            }
            AppSharedPreferences.getInstance(context).setString(StampConstants.SP_NAME, StampConstants.SP_KEY_TEXT_STAMPS, jsonArray.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveImageStamps(Context context, List<ImageStampBean> stamps) {
        if (stamps == null || stamps.size() == 0) return;

        JSONArray jsonArray = new JSONArray();
        try {
            for (ImageStampBean stampBean : stamps) {
                if (!AppUtil.isEmpty(stampBean.mCacheFile)) {
                    File file = new File(stampBean.mCacheFile);
                    if (file.exists()) {
                        JSONObject object = new JSONObject();
                        object.put("createTime", stampBean.mCreateTime);
                        object.put("modifiedTime", stampBean.mModifiedTime);
                        object.put("opacity", stampBean.mOpacity);
                        object.put("width", stampBean.mWidth);
                        object.put("height", stampBean.mHeight);
                        object.put("cacheFile", stampBean.mCacheFile);
                        jsonArray.put(object);
                    }
                }
            }
            AppSharedPreferences.getInstance(context).setString(StampConstants.SP_NAME, StampConstants.SP_KEY_IMAGE_STAMPS, jsonArray.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getCustomDateString(String author, TextStampBean stampBean) {
        StringBuilder sb = new StringBuilder();
        if (stampBean.mShowAuthor) {
            sb.append(author);
        }
        if (stampBean.mShowTime) {
            if (stampBean.mShowAuthor)
                sb.append(",");
            sb.append(StampUtil.formatTime(stampBean.mCreateTime));
        }
        if (stampBean.mShowDate) {
            if (stampBean.mShowAuthor || stampBean.mShowTime)
                sb.append(",");
            sb.append(StampUtil.formatDate(stampBean.mCreateTime));
        }
        return sb.toString();
    }

    public static String getCustomDateScript(TextStampBean stampBean) {
        String authorScript = "";
        String dateScript = "";
        if (stampBean.mShowAuthor) {
            authorScript = "event.value = ((!identity.name || identity.loginName != (event.source.source || this).Collab.user) ? (event.source.source || this).Collab.user : identity.name)\n";
        }

        if (stampBean.mShowTime) {
            dateScript = "\n" +
                    "event.value = (new Date()).toString();\n" +
                    "AFDate_FormatEx(\"HH:MM:ss\");\n";
        }

        if (stampBean.mShowDate) {
            if (stampBean.mShowTime) {
                dateScript = "\n" +
                        "event.value = (new Date()).toString();\n" +
                        "AFDate_FormatEx(\"HH:MM:ss, dd/mm/yyyy\");\n";
            } else {
                dateScript = "\n" +
                        "event.value = (new Date()).toString();\n" +
                        "AFDate_FormatEx(\"dd/mm/yyyy\");\n";
            }
        }

        StringBuilder sb = new StringBuilder();
        if (AppUtil.isEmpty(authorScript) || AppUtil.isEmpty(dateScript)) {
            sb.append(dateScript).append(authorScript);
        } else {
            sb.append(dateScript);
            sb.append(authorScript);
            sb.append(" + \" , \" + event.value;\n");
        }
        return sb.toString();
    }

    public static boolean isEmojiCharacter(int codePoint) {
        return codePoint == 0x0
                || codePoint == 0x9
                || codePoint == 0xa9
                || codePoint == 0xae
                || codePoint == 0x303d
                || codePoint == 0x3030
                || codePoint == 0x2b55
                || codePoint == 0x2b1c
                || codePoint == 0x2b1b
                || codePoint == 0x2b50
                || codePoint >= 0x1F0CF && codePoint <= 0x1F6B8
                || codePoint == 0xD
                || codePoint >= 0x2100 && codePoint <= 0x27FF
                || codePoint >= 0x2B05 && codePoint <= 0x2B07
                || codePoint >= 0x2934 && codePoint <= 0x2935
                || codePoint >= 0x203C && codePoint <= 0x2049
                || codePoint >= 0x3297 && codePoint <= 0x3299
                || codePoint >= 0xDC00 && codePoint <= 0xE678;

    }

    public static String getImageCacheDir(Context context) {
        return AppFileUtil.getExternalFilePath(context, Environment.DIRECTORY_DCIM) + "/custom_stamps/";
    }

    public static String savePicWithOpacity(String sourcePath, int opacity) {
        File file = new File(sourcePath);
        if (file.exists()) {
            Bitmap sourceBmp = BitmapFactory.decodeFile(sourcePath).copy(Bitmap.Config.ARGB_8888, true);
            sourceBmp.setHasAlpha(true);
//            for(int y = 0; y < sourceBmp.getHeight(); y++){
//                for(int x = 0; x < sourceBmp.getWidth(); x++){
//                    int pixel = sourceBmp.getPixel(x, y);
//                    int newPixel = Color.argb(AppDmUtil.opacity100To255(opacity), Color.red(pixel), Color.green(pixel), Color.blue(pixel));
//                    sourceBmp.setPixel(x, y, newPixel);
//                }
//            }

            int[] argb = new int[sourceBmp.getWidth() * sourceBmp.getHeight()];
            sourceBmp.getPixels(argb, 0, sourceBmp.getWidth(), 0, 0, sourceBmp.getWidth(), sourceBmp.getHeight());
            opacity = opacity * 255 / 100;
            for (int i = 0; i < argb.length; i++) {
                argb[i] = (opacity << 24) | (argb[i] & 0x00FFFFFF);
            }

            sourceBmp = Bitmap.createBitmap(argb, sourceBmp.getWidth(), sourceBmp.getHeight(), Bitmap.Config.ARGB_8888);
            String folder = AppFileUtil.getFileFolder(sourcePath);
            String fileName = AppFileUtil.getFileNameWithoutExt(sourcePath) + "_temp.png";
            String savePath = AppFileUtil.saveBitmap(folder, fileName, sourceBmp);
            if (sourceBmp != null && !sourceBmp.isRecycled()) {
                sourceBmp.recycle();
            }
            return savePath;
        } else {
            return sourcePath;
        }
    }

    public static String convertImageToPDF(String soucrePath, int opacity) {
        try {
            //String tempPath = StampUtil.savePicWithOpacity(soucrePath, opacity); //todo There is a problem with modifying transparency.
            String cachePDF = AppFileUtil.replaceFileExtension(soucrePath, ".pdf");
            AppFileUtil.deleteFile(cachePDF);

            Convert.fromImage(soucrePath, cachePDF);
            //AppFileUtil.deleteFile(tempPath);
            return cachePDF;
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return null;
    }

}
