/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.textmarkup.highlight;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.annots.Highlight;
import com.foxit.sdk.pdf.annots.Markup;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.common.EditAnnotEvent;
import com.foxit.uiextensions.annots.textmarkup.TextmarkupConstants;
import com.foxit.uiextensions.utils.AppDmUtil;

public class HighlightEvent extends EditAnnotEvent {

    public HighlightEvent(int eventType, HighlightUndoItem undoItem, Highlight highlight, PDFViewCtrl pdfViewCtrl) {
        mType = eventType;
        mUndoItem = undoItem;
        mAnnot = highlight;
        mPdfViewCtrl = pdfViewCtrl;
    }

    @Override
    public boolean add() {
        if (mAnnot == null || !(mAnnot instanceof Highlight)) {
            return false;
        }
        Highlight annot = (Highlight) mAnnot;
        try {
            HighlightAddUndoItem undoItem = (HighlightAddUndoItem) mUndoItem;

            annot.setBorderColor(undoItem.mColor);
            if (undoItem.quadPointsArray != null) {
                annot.setQuadPoints(undoItem.quadPointsArray);
            }
            annot.setOpacity(undoItem.mOpacity);
            if (undoItem.mContents != null) {
                annot.setContent(undoItem.mContents);
            }
            annot.setFlags(undoItem.mFlags);
            if (undoItem.mCreationDate != null && AppDmUtil.isValidDateTime(undoItem.mCreationDate)) {
                annot.setCreationDateTime(undoItem.mCreationDate);
            }
            if (undoItem.mModifiedDate != null && AppDmUtil.isValidDateTime(undoItem.mModifiedDate)) {
                annot.setModifiedDateTime(undoItem.mModifiedDate);
            }
            if (undoItem.mAuthor != null) {
                annot.setTitle(undoItem.mAuthor);
            }

            if (undoItem.mSubject != null) {
                annot.setSubject(undoItem.mSubject);
            }
            if (undoItem.mIntent != null)
                annot.setIntent(undoItem.mIntent);
            if (undoItem.mbAreaHi) {
                annot.getDict().setAtString(TextmarkupConstants.AREA_HIGHLIGHT, TextmarkupConstants.AREA_HIGHLIGHT);
            }
            annot.setUniqueID(undoItem.mNM);
            if (undoItem.mReplys != null)
                undoItem.mReplys.addReply(annot, undoItem.mReplys);
            annot.resetAppearanceStream();
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            if (e.getLastError() == Constants.e_ErrOutOfMemory) {
                mPdfViewCtrl.recoverForOOM();
            }
        }
        return false;
    }

    @Override
    public boolean modify() {
        if (mAnnot == null || !(mAnnot instanceof Highlight)) {
            return false;
        }
        Highlight annot = (Highlight) mAnnot;
        try {
            if (((HighlightModifyUndoItem)mUndoItem).quadPointsArray != null) {
                annot.setQuadPoints(((HighlightModifyUndoItem)mUndoItem).quadPointsArray);
            }

            if (mUndoItem.mModifiedDate != null) {
                annot.setModifiedDateTime(mUndoItem.mModifiedDate);
            }
            if (mUndoItem.mContents != null) {
                annot.setContent(mUndoItem.mContents);
            }
            annot.setBorderColor(mUndoItem.mColor);
            annot.setOpacity(mUndoItem.mOpacity);
            annot.resetAppearanceStream();
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            if (e.getLastError() == Constants.e_ErrOutOfMemory) {
                mPdfViewCtrl.recoverForOOM();
            }
        }
        return false;
    }

    @Override
    public boolean delete() {
        if (mAnnot == null || !(mAnnot instanceof Highlight)) {
            return false;
        }

        try {
            ((Markup)mAnnot).removeAllReplies();
            PDFPage page = mAnnot.getPage();
            page.removeAnnot(mAnnot);
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            e.printStackTrace();
        }

        return false;
    }
}
