/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.browser.behavior;


import android.content.Context;
import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;


public class NestedHeaderScrollBehavior extends CoordinatorLayout.Behavior<View> {

    public NestedHeaderScrollBehavior(Context context) {
        this(context, null);
    }

    public NestedHeaderScrollBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent,
                                   @NonNull View child, @NonNull View dependency) {
        return dependency == parent.getChildAt(1);
    }

    @Override
    public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent,
                                          @NonNull View child, @NonNull View dependency) {
        if (dependency.getTag() instanceof Integer) {
            int tag = (int) dependency.getTag();
            if (tag == NestedHeaderBehavior.HIDE || tag == NestedHeaderBehavior.FIXED) {
                return false;
            }
        }

        float translationY = Math.abs(dependency.getTranslationY());
        float alpha = (child.getMeasuredHeight() - translationY) / child.getMeasuredHeight();
        child.setAlpha(alpha);
        return true;
    }

}
