/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.config.modules;

import com.foxit.uiextensions.config.Config;
import com.foxit.uiextensions.config.modules.annotations.AnnotationsConfig;
import com.foxit.uiextensions.utils.JsonUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

public class ModulesConfig {
    public static final String KEY_MODULE_ANNOTATIONS = "annotations";

    private static final String KEY_MODULE_READINGBOOKMARK = "readingbookmark";
    private static final String KEY_MODULE_OUTLINE = "outline";
    private static final String KEY_MODULE_THUMBNAIL = "thumbnail";
    private static final String KEY_MODULE_ATTACHMENT = "attachment";
    private static final String KEY_MODULE_SIGNATURE = "signature";
    private static final String KEY_MODULE_FILLSIGN = "fillSign";
    private static final String KEY_MODULE_SEARCH = "search";
    private static final String KEY_MODULE_SELECTION = "selection";

    private static final String KEY_MODULE_OLD_PAGENAVIGATION = "pageNavigation";
    private static final String KEY_MODULE_PAGENAVIGATION = "navigation";

    private static final String KEY_MODULE_ENCRYPTION = "encryption";
    private static final String KEY_MODULE_FORM = "form";
    private static final String KEY_MODULE_MULTI_SELECT = "multipleSelection";

    public boolean isLoadReadingBookmark = true;
    public boolean isLoadOutline = true;
    public boolean isLoadAnnotations = true;
    public boolean isLoadThumbnail = true;
    public boolean isLoadAttachment = true;
    public boolean isLoadSignature = true;
    public boolean isLoadFillSign = true;
    public boolean isLoadSearch = true;
    public boolean isLoadTextSelection = true;
    public boolean isLoadPageNavigation = true;
    public boolean isLoadFileEncryption = true;
    public boolean isLoadForm = true;
    public boolean isLoadMultiSelect = true;

    public AnnotationsConfig annotations;

    public ModulesConfig() {
        annotations = new AnnotationsConfig();
    }

    public void parseConfig(JSONObject jsonObject) {
        try {
            JSONObject modules = jsonObject.getJSONObject(Config.KEY_MODULES);
            isLoadReadingBookmark = JsonUtil.getBoolean(modules, KEY_MODULE_READINGBOOKMARK, true);
            isLoadOutline = JsonUtil.getBoolean(modules, KEY_MODULE_OUTLINE, true);
            isLoadThumbnail = JsonUtil.getBoolean(modules, KEY_MODULE_THUMBNAIL, true);
            isLoadAttachment = JsonUtil.getBoolean(modules, KEY_MODULE_ATTACHMENT, true);
            isLoadSignature = JsonUtil.getBoolean(modules, KEY_MODULE_SIGNATURE, true);
            isLoadFillSign = JsonUtil.getBoolean(modules, KEY_MODULE_FILLSIGN, true);
            isLoadSearch = JsonUtil.getBoolean(modules, KEY_MODULE_SEARCH, true);
            isLoadTextSelection = JsonUtil.getBoolean(modules, KEY_MODULE_SELECTION, true);

            String[] navigationKeys = new String[]{KEY_MODULE_OLD_PAGENAVIGATION, KEY_MODULE_PAGENAVIGATION};
            for (String str : navigationKeys) {
                if (modules.has(str) && modules.get(str) instanceof Boolean) {
                    isLoadPageNavigation = JsonUtil.getBoolean(modules, str, true);
                    break;
                }
            }

            isLoadFileEncryption = JsonUtil.getBoolean(modules, KEY_MODULE_ENCRYPTION, true);
            isLoadForm = JsonUtil.getBoolean(modules, KEY_MODULE_FORM, true);
            isLoadMultiSelect = JsonUtil.getBoolean(modules, KEY_MODULE_MULTI_SELECT, true);

            annotations.setLoadAttachment(isLoadAttachment);
            if (modules.has(KEY_MODULE_ANNOTATIONS)) {
                if (modules.get(KEY_MODULE_ANNOTATIONS) instanceof JSONObject) {
                    annotations.parseConfig(modules);

                    boolean isLoadAnnotsConfig = false;
                    Map<String, Boolean> mAnnotState = annotations.getAnnotConfigMap();
                    for (Boolean bool : mAnnotState.values()) {
                        if (bool) {
                            isLoadAnnotsConfig = true;
                            break;
                        }
                    }
                    isLoadAnnotations = isLoadAnnotsConfig || isLoadAttachment;
                } else {
                    boolean isLoadAnnotsConfig = JsonUtil.getBoolean(modules, KEY_MODULE_ANNOTATIONS, true);
                    if (!isLoadAnnotsConfig) {
                        annotations.closeAnnotsConfig();
                    }
                    isLoadAnnotations = isLoadAnnotsConfig || isLoadAttachment;
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void enableAnnotations(boolean enable) {
        isLoadAnnotations = enable;
        isLoadAttachment = enable;
        annotations.setLoadAttachment(enable);
        if (!enable) {
            annotations.closeAnnotsConfig();
        }
    }

}
