/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.config.modules.annotations;


import com.foxit.uiextensions.config.JsonConstants;
import com.foxit.uiextensions.config.modules.ModulesConfig;
import com.foxit.uiextensions.utils.JsonUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class AnnotationsConfig {
    public boolean isLoadHighlight = true;
    public boolean isLoadUnderline = true;
    public boolean isLoadSquiggly = true;
    public boolean isLoadStrikeout = true;
    public boolean isLoadRedaction = true;
    public boolean isLoadInsertText = true;
    public boolean isLoadReplaceText = true;

    public boolean isLoadLine = true;
    public boolean isLoadSquare = true;
    public boolean isLoadCircle = true;
    public boolean isLoadArrow = true;
    public boolean isLoadMeasure = true;
    public boolean isLoadPencil = true;
    public boolean isLoadEraser = true;
    public boolean isLoadPolygon = true;
    public boolean isLoadCloud = true;
    public boolean isLoadPolyLine = true;

    public boolean isLoadTypewriter = true;
    public boolean isLoadTextbox = true;
    public boolean isLoadCallout = true;
    public boolean isLoadNote = true;
    public boolean isLoadStamp = true;
    public boolean isLoadFileattachment = true;
    public boolean isLoadImage = true;
    public boolean isLoadAudio = true;
    public boolean isLoadVideo = true;

    private Map<String, Boolean> mMapSaveAnnotConfig = new HashMap<String, Boolean>();

    public void parseConfig(JSONObject jsonObject) {
        try {
            JSONObject annotObject = jsonObject.getJSONObject(ModulesConfig.KEY_MODULE_ANNOTATIONS);
            isLoadHighlight = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_HIGHLIGHT, true);
            isLoadUnderline = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_UNDERLINE, true);
            isLoadSquiggly = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_SQUIGGLY, true);
            isLoadStrikeout = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_STRIKEOUT, true);
            isLoadRedaction = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_REDACTION, true);

            String[] insertKeys = new String[]{JsonConstants.TYPE_OLD_INSERT, JsonConstants.TYPE_CARET};
            for (String str : insertKeys) {
                if (annotObject.has(str) && annotObject.get(str) instanceof Boolean) {
                    isLoadInsertText = JsonUtil.getBoolean(annotObject, str, true);
                    break;
                }
            }
            String[] replaceKeys = new String[]{JsonConstants.TYPE_OLD_REPLACE, JsonConstants.TYPE_REPLACE};
            for (String str : replaceKeys) {
                if (annotObject.has(str) && annotObject.get(str) instanceof Boolean) {
                    isLoadReplaceText = JsonUtil.getBoolean(annotObject, str, true);
                    break;
                }
            }

            isLoadLine = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_LINE, true);
            isLoadSquare = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_SQUARE, true);
            isLoadCircle = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_CIRCLE, true);
            isLoadArrow = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_LINEARROW, true);
            isLoadPencil = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_INK, true);
            isLoadEraser = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_ERASER, true);
            isLoadPolygon = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_POLYGON, true);
            isLoadCloud = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_POLYGONCLOUD, true);
            isLoadPolyLine = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_POLYLINE, true);

            isLoadTypewriter = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_TYPEWRITER, true);
            isLoadCallout = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_CALLOUT, true);
            isLoadTextbox = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_TEXTBOX, true);
            isLoadNote = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_NOTE, true);
            isLoadStamp = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_STAMP, true);
            isLoadMeasure = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_LINEDIMENSION, true);
            isLoadImage = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_SCREEN_IMAGE, true);
            isLoadAudio = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_AUDIO, true);
            isLoadVideo = JsonUtil.getBoolean(annotObject, JsonConstants.TYPE_VIDEO, true);

            initMap();
        }catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void closeAnnotsConfig() {
        isLoadHighlight = false;
        isLoadUnderline = false;
        isLoadSquiggly = false;
        isLoadStrikeout = false;
        isLoadRedaction = false;
        isLoadInsertText = false;
        isLoadReplaceText = false;

        isLoadLine = false;
        isLoadSquare = false;
        isLoadCircle = false;
        isLoadArrow = false;
        isLoadPencil = false;
        isLoadEraser = false;
        isLoadPolygon = false;
        isLoadCloud = false;
        isLoadPolyLine = false;

        isLoadTypewriter = false;
        isLoadCallout = false;
        isLoadTextbox = false;
        isLoadNote = false;
        isLoadStamp = false;
//                isLoadFileattachment = false;
        isLoadMeasure = false;
        isLoadImage = false;
        isLoadAudio = false;
        isLoadVideo = false;
    }

    private void initMap() {
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_HIGHLIGHT, isLoadHighlight);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_UNDERLINE, isLoadUnderline);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_SQUIGGLY, isLoadSquiggly);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_STRIKEOUT, isLoadStrikeout);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_REDACTION, isLoadRedaction);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_CARET, isLoadInsertText);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_REPLACE, isLoadReplaceText);

        mMapSaveAnnotConfig.put(JsonConstants.TYPE_LINE, isLoadLine);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_SQUARE, isLoadSquare);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_CIRCLE, isLoadCircle);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_LINEARROW, isLoadArrow);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_INK, isLoadPencil);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_ERASER, isLoadEraser);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_POLYGON, isLoadPolygon);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_POLYGONCLOUD, isLoadCloud);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_POLYLINE, isLoadPolyLine);

        mMapSaveAnnotConfig.put(JsonConstants.TYPE_TYPEWRITER, isLoadTypewriter);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_CALLOUT, isLoadCallout);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_TEXTBOX, isLoadTextbox);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_NOTE, isLoadNote);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_STAMP, isLoadStamp);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_LINEDIMENSION, isLoadMeasure);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_SCREEN_IMAGE, isLoadImage);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_AUDIO, isLoadAudio);
        mMapSaveAnnotConfig.put(JsonConstants.TYPE_VIDEO, isLoadVideo);
    }

    public Map<String, Boolean> getAnnotConfigMap() {
        return mMapSaveAnnotConfig;
    }

    public void setLoadAttachment(boolean loadAttachment) {
        isLoadFileattachment = loadAttachment;
    }

}
