/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.config.uisettings.annotations.annots;


import com.foxit.uiextensions.utils.JsonUtil;

import org.json.JSONException;
import org.json.JSONObject;

public class PencilConfig extends BaseConfig {
    public static final int DEFAULT_COLOR = COLORS_TOOL_GROUP_1[0];
    public static final boolean DEFAULT_HISTORICAL_POINTS = false;
    private static final String KEY_HISTORICAL_POINTS = "addHistoricalPoints";
    public boolean addHistoricalPoints = DEFAULT_HISTORICAL_POINTS;
    public PencilConfig() {
        color = DEFAULT_COLOR;
    }

    @Override
    public void parseConfig(JSONObject jsonObject, String name) {
        super.parseConfig(jsonObject, name);
        try {
            JSONObject object = jsonObject.getJSONObject(name);
            if (object.has(KEY_HISTORICAL_POINTS)) {
                addHistoricalPoints = JsonUtil.getBoolean(object, KEY_HISTORICAL_POINTS, DEFAULT_HISTORICAL_POINTS);
            }
            //pen only switch
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AnnotConfigInfo getAnnotConfigInfo() {
        AnnotConfigInfo info = new AnnotConfigInfo();
        info.defaultColor = DEFAULT_COLOR;
        info.defaultOpacity = DEFAULT_OPACITY;
        info.defaultThickness = DEFAULT_THICKNESS;
        return info;
    }

    @Override
    public String getTypeString() {
        return KEY_DRAWING_PENCIL;
    }
}
