/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;

import androidx.fragment.app.FragmentActivity;

import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppUtil;

public class SimpleBottomWindow {

    Context mContext;
    FragmentActivity mActivity;
    UIBottomSheetFragment mWindow;
    private final View mContentView;
    private DialogInterface.OnDismissListener mOnDismissListener;

    public SimpleBottomWindow(Context context, View contentView) {
        mContext = context.getApplicationContext();
        mActivity = (FragmentActivity) context;
        mContentView = contentView;
        initWindow();
    }

    private void initWindow() {
        if (mWindow != null) return;
        mWindow = UIBottomSheetFragment.newInstance(mActivity, mContentView);
        if (AppDisplay.isLandscape()) {
            mWindow.setWidth(AppDisplay.getActivityWidth() / 2);
        } else {
            mWindow.setWidth(ViewGroup.LayoutParams.MATCH_PARENT);
        }
        mWindow.setHeight(AppDisplay.getActivityHeight() * 2 / 3);
        mWindow.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                if (mOnDismissListener != null)
                    mOnDismissListener.onDismiss(dialog);
                mWindow = null;
                AppUtil.removeViewFromParent(mContentView);
            }
        });
    }

    public void show() {
        initWindow();
        int width;
        if (AppDisplay.isLandscape()) {
            width = Math.min(AppDisplay.getActivityWidth(), AppDisplay.getActivityHeight());
        } else {
            width = ViewGroup.LayoutParams.MATCH_PARENT;
        }
        mWindow.setWidth(width);
        mWindow.setHeight(AppDisplay.getActivityHeight() * 2 / 3);
        if (!mWindow.isShowing()) {
            mWindow.showAtLocation(Gravity.BOTTOM, 0, 0);
        }
    }

    public void dismiss() {
        if (mWindow == null) return;
        mWindow.dismiss();
    }

    public boolean isShowing() {
        return mWindow != null && mWindow.isShowing();
    }

    public UIBottomSheetFragment getWindow() {
        initWindow();
        return mWindow;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener dismissListener) {
        mOnDismissListener = dismissListener;
    }
}
