/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog.sheetmenu;


import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

import androidx.annotation.IntDef;

public interface ISheetMenu {

    int NORMAL_MODE = 0;
    int SELECTED_MODE = 1;

    @IntDef({
            NORMAL_MODE,
            SELECTED_MODE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface SheetMode {
    }

    int REPLY_MENU = 0;
    int COMMENT_MENU = 1;
    int FLATTEN_MENU = 2;
    int RENAME_MENU = 3;
    int DELETE_MENU = 4;
    int SAVE_MENU = 5;
    int DESC_MENU = 6;

    int SIGN_MENU = 7;
    int CHECK_SIGNATURE_MENU = 8;
    int VERIFY_SIGNATURE_MENU = 9;
    int INFO_SIGNATURE_MENU = 10;
    int TRUST_SIGNATURE_MENU = 11;

    int GROUP_LIST_MENU = 12;

    int APPLY_MENU = 13;

    int EDIT_MENU = 14;

    int CAMERA_MENU = 15;
    int GALLERY_MENU = 16;

    @IntDef({
            REPLY_MENU,
            COMMENT_MENU,
            FLATTEN_MENU,
            RENAME_MENU,
            DELETE_MENU,
            SAVE_MENU,
            DESC_MENU,
            SIGN_MENU,
            CHECK_SIGNATURE_MENU,
            VERIFY_SIGNATURE_MENU,
            INFO_SIGNATURE_MENU,
            TRUST_SIGNATURE_MENU,
            GROUP_LIST_MENU,
            APPLY_MENU,
            EDIT_MENU,
            CAMERA_MENU,
            GALLERY_MENU})
    @Retention(RetentionPolicy.SOURCE)
    @interface SheetMenu {
    }

    interface OnSheetItemClickListener {
        void onItemClick(int type);
    }

    interface OnSheetDismissListener {
        /**
         * This method will be invoked when the dialog is dismissed.
         *
         * @param sheetMenu the dialog that was dismissed will be passed into the
         *                  method
         */
        void onDismiss(ISheetMenu sheetMenu);
    }

    void setSheetItemClickListener(OnSheetItemClickListener itemClickListener);

    void setOnSheetDismissListener(OnSheetDismissListener dismissListener);

    void addSheetItem(@SheetMenu int type);

    void addSheetItem(@SheetMenu int type, boolean enabled);

    void setSheetItemEnabled(@SheetMenu int type, boolean enabled);

    void setSheetItemSelected(int type, boolean selected);

    void addCustomSheetItem(SheetItemBean itemBean);

    void setSheetItems(List<Integer> items);

    void setCustomSheetItem(List<SheetItemBean> itemBeans);

    void removeSheetItem(int type);

    void show(ViewGroup parent, Rect rect);

    void show(ViewGroup parent, Rect rect, int arrowPos);

    void show(ViewGroup parent, Rect rect, int arrowPos, int arrowDist);

    void update(ViewGroup parent, Rect rect, int arrowPosition);

    void dismiss();

    boolean isShowing();

    void setWidth(int width);

    int getMeasureWidth();

    void setHeight(int height);

    int getMeasureHeight();

    void setMode(@SheetMode int mode);

    void setTitle(String title);

    View getContentView();

    void updateTheme();

    void setAutoResetSystemUiOnShow(boolean auto);
}
