/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog.sheetmenu;


import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;
import java.util.List;

class SheetMenuAdapter extends BaseAdapter {
    private Context mContext;
    private List<SheetItemBean> mSheetItemBeans;

    private int mMode = ISheetMenu.NORMAL_MODE;

    SheetMenuAdapter(Context context) {
        this.mContext = context;
        mSheetItemBeans = new ArrayList<>();
    }

    List<SheetItemBean> getSheetItems() {
        return mSheetItemBeans;
    }

    void setSheetItems(List<SheetItemBean> items) {
        this.mSheetItemBeans = items;
    }

    void clear() {
        mSheetItemBeans.clear();
    }

    void addSheetItem(SheetItemBean itemBean) {
        mSheetItemBeans.add(itemBean);
    }

    void setMode(@ISheetMenu.SheetMode int mode) {
        this.mMode = mode;
    }

    int getMode() {
        return mMode;
    }

    @Override
    public int getCount() {
        return mSheetItemBeans.size();
    }

    @Override
    public SheetItemBean getItem(int position) {
        return mSheetItemBeans.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(mContext).inflate(R.layout.bottom_sheet_item, parent, false);
            holder.mIconIv = convertView.findViewById(R.id.iv_item_type_icon);
            holder.mNameTv = convertView.findViewById(R.id.tv_item_type_name);
            holder.mCheckedView = convertView.findViewById(R.id.tv_item_type_checked);

            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        SheetItemBean itemBean = mSheetItemBeans.get(position);
        if (itemBean.iconResId > 0) {
            holder.mIconIv.setImageResource(itemBean.iconResId);
            holder.mIconIv.setEnabled(itemBean.enabled);
            holder.mIconIv.setVisibility(View.VISIBLE);
            ThemeUtil.setTintList(holder.mIconIv, ThemeUtil.getListIconColor(mContext));
        } else {
            holder.mIconIv.setVisibility(View.GONE);
        }
        holder.mNameTv.setText(itemBean.name);
        holder.mNameTv.setEnabled(itemBean.enabled);
        holder.mNameTv.setTextColor(ThemeUtil.getListTextColor(mContext));
        if (mMode == ISheetMenu.NORMAL_MODE) {
            holder.mCheckedView.setVisibility(View.GONE);
        } else if (mMode == ISheetMenu.SELECTED_MODE) {
            holder.mNameTv.setSelected(itemBean.selected);
            holder.mIconIv.setSelected(itemBean.selected);
            holder.mCheckedView.setSelected(itemBean.selected);

            holder.mCheckedView.setVisibility(itemBean.selected ? View.VISIBLE : View.INVISIBLE);
            ThemeUtil.setTintList(holder.mCheckedView, ThemeUtil.getPrimaryIconColor(mContext));
        }
        convertView.setBackground(AppResource.getDrawable(mContext, R.drawable.common_list_item_bg));
        return convertView;
    }

    private static class ViewHolder {
        private ImageView mIconIv;
        private TextView mNameTv;
        private ImageView mCheckedView;
    }

    void addSubMenu(@ISheetMenu.SheetMenu int type, boolean enabled) {
        SheetItemBean sheetItem;
        if (type == ISheetMenu.REPLY_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.REPLY_MENU, R.drawable.rd_reply_menu, getString(R.string.fx_string_reply), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.COMMENT_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.COMMENT_MENU, R.drawable.rd_comment_menu, getString(R.string.fx_string_note), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.DESC_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.COMMENT_MENU, R.drawable.rd_comment_menu, getString(R.string.rv_panel_edit_desc), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.FLATTEN_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.FLATTEN_MENU, R.drawable.rd_flatten_menu, getString(R.string.fx_string_flatten), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.RENAME_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.RENAME_MENU, R.drawable.rd_rename_menu, getString(R.string.fx_string_rename), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.DELETE_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.DELETE_MENU, R.drawable.rd_delete_menu, getString(R.string.fx_string_delete), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.SAVE_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.SAVE_MENU, R.drawable.rd_save_menu, getString(R.string.fx_string_save), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.SIGN_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.SIGN_MENU, R.drawable.rd_sign_menu, getString(R.string.rv_sign_dialog_title), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.CHECK_SIGNATURE_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.CHECK_SIGNATURE_MENU, R.drawable.rd_check_signature_menu, getString(R.string.rv_panel_signature_view), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.VERIFY_SIGNATURE_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.VERIFY_SIGNATURE_MENU, R.drawable.rd_verify_signature_menu, getString(R.string.rv_panel_signature_verify), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.INFO_SIGNATURE_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.INFO_SIGNATURE_MENU, R.drawable.rd_information_menu, getString(R.string.fx_string_info), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.TRUST_SIGNATURE_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.TRUST_SIGNATURE_MENU, R.drawable.rd_trust_menu, getString(R.string.rv_trust_certificate), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.GROUP_LIST_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.GROUP_LIST_MENU, R.drawable.rd_group_list_menu, getString(R.string.rd_sheet_menu_group_list), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.APPLY_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.APPLY_MENU, R.drawable.ic_redaction_apply, getString(R.string.fx_string_apply), enabled);
            addSheetItem(sheetItem);
        } else if (type == ISheetMenu.EDIT_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.EDIT_MENU, R.drawable.rd_edit_menu, getString(R.string.fx_string_edit), enabled);
            addSheetItem(sheetItem);
        }else if (type == ISheetMenu.CAMERA_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.CAMERA_MENU, R.drawable.thumbnail_add_from_camera, getString(R.string.fx_import_camera), enabled);
            addSheetItem(sheetItem);
        }else if (type == ISheetMenu.GALLERY_MENU) {
            sheetItem = new SheetItemBean(ISheetMenu.GALLERY_MENU, R.drawable.thumbnail_add_from_image, getString(R.string.fx_import_dcim), enabled);
            addSheetItem(sheetItem);
        }
    }

    public void setSheetItemEnabled(@ISheetMenu.SheetMenu int type, boolean enabled) {
        for (SheetItemBean itemBean : mSheetItemBeans) {
            if (itemBean.type == type) {
                itemBean.enabled = enabled;
                notifyDataSetChanged();
                break;
            }
        }
    }

    private String getString(int strId) {
        return AppResource.getString(mContext, strId);
    }
}
