/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog.sheetmenu;


import android.content.DialogInterface;
import android.graphics.Rect;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;

import com.foxit.uiextensions.controls.dialog.UIBottomSheetFragment;
import com.foxit.uiextensions.utils.AppDevice;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.SystemUiHelper;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;

public class UIBottomSheetMenu extends UISheetMenu {

    private UIBottomSheetFragment mBottomSheetDialog;
    private FragmentActivity mFragmentActivity;

    public static UIBottomSheetMenu create(@NonNull FragmentActivity context) {
        return new UIBottomSheetMenu(context);
    }

    private UIBottomSheetMenu(@NonNull FragmentActivity context) {
        super(context, true);
        mFragmentActivity = context;
        initUIBottomSheetMenu();
    }

    private void initUIBottomSheetMenu() {
        if (mBottomSheetDialog != null) return;
        mBottomSheetDialog = UIBottomSheetFragment.newInstance(mFragmentActivity, mContentView);
        mBottomSheetDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                if (mOnSheetDismissListener != null)
                    mOnSheetDismissListener.onDismiss(UIBottomSheetMenu.this);
                AppUtil.removeViewFromParent(mContentView);
                mBottomSheetDialog = null;
            }
        });
    }

    @Override
    public void show(ViewGroup parent, Rect rect) {
        initUIBottomSheetMenu();
        if (mSheetMenuAdapter.getCount() > 0) {
            measure();
            int measureHeight = getMeasureHeight();
            int sheetHeight;
            int sheetWidth;
            int width = parent.getWidth();
            int height = parent.getHeight();
            if (AppDisplay.isLandscape()) {
                int statusBarHeight = 0;
                if (SystemUiHelper.getInstance().isStatusBarShown(mAct)) {
                    statusBarHeight = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
                }
                sheetWidth = Math.min(width, height) + statusBarHeight;
            } else {
                sheetWidth = width;
            }

            int screenHeight = AppDevice.isChromeOs(mAct) ? AppDisplay.getActivityHeight() :AppDisplay.getRawScreenHeight();
            if (screenHeight != height)
                sheetHeight = measureHeight + AppDisplay.getNavBarHeight();
            else
                sheetHeight = measureHeight;
            mBottomSheetDialog.setWidth(sheetWidth);
            mBottomSheetDialog.setHeight(sheetHeight);
            if (isShowing()) {
                mBottomSheetDialog.update(0, 0, sheetWidth, sheetHeight);
            } else {
                mBottomSheetDialog.showAtLocation(Gravity.BOTTOM, 0, 0);
            }
        }
    }

    @Override
    public void show(ViewGroup parent, Rect rect, int arrowPos) {
        show(parent, rect);
    }

    @Override
    public void show(ViewGroup parent, Rect rect, int arrowPos, int arrowDist) {
        show(parent, rect);
    }

    @Override
    public void update(ViewGroup parent, Rect rect, int arrowPosition) {
        show(parent, rect, arrowPosition);
    }

    @Override
    public boolean isShowing() {
        return mBottomSheetDialog !=null && mBottomSheetDialog.isShowing();
    }

    @Override
    public View getContentView() {
        return mContentView;
    }

    @Override
    public void dismiss() {
        if (mBottomSheetDialog == null) return;
        mBottomSheetDialog.dismiss();
    }

}
