/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog.sheetmenu;


import android.graphics.Rect;
import android.view.ViewGroup;
import android.widget.PopupWindow;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.controls.dialog.UIPopoverFrag;
import com.foxit.uiextensions.controls.dialog.UIPopoverWin;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

import androidx.fragment.app.FragmentActivity;

public class UIPopSheetMenu extends UISheetMenu {
    private UIPopoverFrag mSheetMenu;

    public static UIPopSheetMenu create(FragmentActivity context) {
        return new UIPopSheetMenu(context);
    }

    private UIPopSheetMenu(FragmentActivity context) {
        super(context, false);
        initSheetMenu();
    }

    @Override
    public boolean isShowing() {
        if (mSheetMenu != null)
            return mSheetMenu.isShowing();
        return false;
    }

    @Override
    public void dismiss() {
        if (mSheetMenu != null && mSheetMenu.isShowing()) {
            mSheetMenu.dismiss();
        }
    }

    @Override
    public void show(ViewGroup parent, Rect rect) {
        show(parent, rect, UIPopoverWin.ARROW_RIGHT);
    }

    @Override
    public void show(ViewGroup parent, Rect rect, int arrowPos) {
        show(parent, rect, arrowPos, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_4dp));
    }

    @Override
    public void show(ViewGroup parent, Rect rect, int arrowPos, int arrowDist) {
        measure();
        int width = getMeasureWidth();
        int height = getMeasureHeight();
        if (isShowing()) {
            getSheetMenu().update(parent, rect, width, height);
        } else {
            getSheetMenu().showAtLocation(parent, rect, width, height, arrowPos, arrowDist);
        }
    }

    @Override
    public void update(ViewGroup parent, Rect rect, int arrowPosition) {
        measure();
        int width = getMeasureWidth();
        int height = getMeasureHeight();
        if (isShowing())
            getSheetMenu().update(parent, rect, width, height, arrowPosition);
    }

    public UIPopoverFrag getSheetMenu() {
        initSheetMenu();
        return mSheetMenu;
    }

    @Override
    public void updateTheme() {
        super.updateTheme();
        getSheetMenu().setArrowColor(AppResource.getColor(mContext, R.color.b1));
    }

    @Override
    public void setAutoResetSystemUiOnShow(boolean auto) {
        getSheetMenu().setAutoResetSystemUiOnShow(auto);
    }

    private void initSheetMenu() {
        if (mSheetMenu != null) return;
        mSheetMenu = UIPopoverFrag.create((FragmentActivity) mAct, mContentView, false, false);
//        mSheetMenu.setOutsideTouchable(true);
//        mSheetMenu.setFocusable(true);

        mSheetMenu.setOnDismissListener(new PopupWindow.OnDismissListener() {
            @Override
            public void onDismiss() {
                if (mOnSheetDismissListener != null)
                    mOnSheetDismissListener.onDismiss(UIPopSheetMenu.this);
                AppUtil.removeViewFromParent(mContentView);
                mSheetMenu = null;
            }
        });
    }
}
