/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.panel;

import android.content.res.ColorStateList;
import android.view.View;

import androidx.annotation.DrawableRes;

/**
 * The interface defines the specific content of the panel.
 * <p>
 * Through this interface, you can set the tab icon, top bar, panel content, etc. of the panel.
 */
public interface PanelSpec {
    /** Reading bookmark panel type. */
    int BOOKMARKS = 0;
    /** Outline panel type. */
    int OUTLINE = 1;
    /** Annotation panel type. */
    int ANNOTATIONS = 2;
    /** Attachment panel type. */
    int ATTACHMENTS = 3;
    /** Signature panel type. */
    int SIGNATURES = 4;

    /**
     * @return a positive integer used to identify the panel tab icon
     */
    @DrawableRes
    int getIcon();

    /** Gets the icon tint for the different states (normal, selected) used for the tab. */
    ColorStateList getIconTint();

    /**
     * @return the panel type start with{@link #BOOKMARKS}
     */
    int getPanelType();

    /**
     * @return the top toolbar of the panel
     */
    View getTopToolbar();

    /**
     * @return the content view of the panel
     */
    View getContentView();

    /**
     * Called when a panel is selected as the current panel.
     */
    void onActivated();

    /**
     * Called when the current panel is changed.
     */
    void onDeactivated();
}
