/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar.imp;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIFillView;

public class CircleColorImageView {
    private View mRootView;
    private UIFillView mColorImageView;
    public CircleColorImageView(Context context) {
        mRootView = LayoutInflater.from(context).inflate(R.layout.circle_color_image_view_layout, null);
        mColorImageView = mRootView.findViewById(R.id.circle_color_image);
    }

    public void setImageColor(int color) {
        mColorImageView.setFillColorFilter(color);
    }


    public void setForceDarkAllowed(boolean allow) {
        if (Build.VERSION.SDK_INT >= 29) {// 29 == Build.VERSION_CODES.Q
            mRootView.setForceDarkAllowed(allow);
        }
    }

    public View getRootView() {
        return mRootView;
    }
}
