/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar.imp;


import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIFillView;
import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

public class ColorView extends FrameLayout {
    private Context mContext;
    private PropertyBarImpl mPropertyBar;
    private PropertyBar.PropertyChangeListener mPropertyChangeListener;

    private ViewGroup mParent;
    private View mCustomColorsView;
    private LinearLayout mCustomPBLlColors;
    private LinearLayout mPBLlColors;
    private TextView mPBColorTitle;

    private int[] mColors;
    private int mColor;
    private int mCurrentWidth;
    private int mPadWidth;
    private boolean canEdit;
    private boolean mIsDefaultColorSelect;
    private boolean mIsCustomColorPage;

    public ColorView(Context context,
                     PropertyBarImpl propertyBar,
                     ViewGroup parent,
                     int color,
                     int[] colors,
                     boolean canEdit) {
        super(context);
        this.mContext = context;
        mPropertyBar = propertyBar;
        this.mParent = parent;
        this.canEdit = canEdit;
        this.mColor = color;
        this.mColors = colors;
        mPadWidth = AppDisplay.dp2px(320.0f);

        init();
    }

    private void init() {
        View colorView = LayoutInflater.from(mContext).inflate(R.layout.pb_color_view, this);
        mPBLlColors = colorView.findViewById(R.id.pb_ll_colors_root);
        mPBColorTitle = colorView.findViewById(R.id.pb_tv_color_title);

        initColors(mPBLlColors);
        if (!canEdit) {
            colorView.setAlpha(PropertyBar.PB_ALPHA);
        }
    }

    private void initColors(LinearLayout pb_ll_colors) {
        pb_ll_colors.removeAllViews();

        int colorWidth = AppDisplay.dp2px(30.0f);
        final int padding = AppDisplay.dp2px(1.0f);
        int space;
        int tempWidth = mParent.getWidth();
        int tempHeight = mParent.getHeight();

        if (AppDisplay.isPad()) {
            mCurrentWidth = mPadWidth;
        } else {
            mCurrentWidth = Math.min(tempWidth, tempHeight);
        }

        int length;
        if (AppDisplay.isPad()) {
            length = mCurrentWidth - AppDisplay.dp2px(16.0f + 4.0f) * 2;
        } else {
            length = mCurrentWidth - AppDisplay.dp2px(16.0f) * 2;
        }

        final int colorsLength = mColors.length + 1;// add custom item
        if (colorsLength > 1) {
            space = (length - colorWidth * colorsLength - padding * 2 * colorsLength) / (colorsLength - 1);
            if (space < 0)
                space = 0;
        } else {
            space = 0;
        }

        for (int i = 0; i < colorsLength; i++) {
            LinearLayout linearLayout = new LinearLayout(mContext);
            LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(colorWidth + padding * 2, colorWidth + padding * 2);
            linearLayout.setOrientation(LinearLayout.HORIZONTAL);
            linearLayout.setGravity(Gravity.CENTER);
            if (i > 0) {
                linearLayoutParams.leftMargin = space;
            } else {
                linearLayoutParams.leftMargin = 0;
            }
            linearLayout.setLayoutParams(linearLayoutParams);
            linearLayout.setTag(i);

            final UIFillView colorView;
            if (i < mColors.length) {
                colorView = new UIFillView(mContext);
                colorView.setForceDarkAllowed(false);

                if (mColors[i] == Color.argb(255, 255, 255, 255)) {
                    colorView.setBorderDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_default_border_color_bg22));
                    colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_default_fill_color_bg22));
                    colorView.setBorderWidth(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_item_border_unselected_width));
                } else if (mColors[i] == Color.argb(0, 0, 0, 0)) {
                    colorView.setBorderDrawale(AppResource.getDrawable(getContext(), R.drawable.pb_fillcolor_none));
                }else{
                    colorView.setBorderDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_default_border_color_bg));
                    colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_default_fill_color_bg));
                }
                colorView.setFillColorFilter(mColors[i]);

                if (mColor == mColors[i]) {
                    mIsDefaultColorSelect = true;
                    linearLayout.setBackgroundResource(R.drawable.common_border_radius_3_rectangle);
                    linearLayout.getBackground().setColorFilter(new PorterDuffColorFilter(ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                } else {
                    linearLayout.setBackgroundColor(Color.TRANSPARENT);
                }
            } else {
                colorView = new UIFillView(mContext);
                colorView.setForceDarkAllowed(false);
                if (mIsDefaultColorSelect) {
                    colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_none_fill_color_bg));
                    colorView.setBorderWidth(0);
                    colorView.setBorderDrawale(null);
                    linearLayout.setBackgroundColor(Color.TRANSPARENT);
                } else {
                    colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_fill_color_bg));
                    colorView.setBorderDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_border_color_bg));
                    colorView.setBorderWidth(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_margin_6dp));
                    colorView.setFillColorFilter(mColor);

                    linearLayout.setBackgroundResource(R.drawable.common_border_radius_3_rectangle);
                    linearLayout.getBackground().setColorFilter(new PorterDuffColorFilter(ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                }
            }
            linearLayout.addView(colorView);
            pb_ll_colors.addView(linearLayout);

            if (canEdit) {
                linearLayout.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (v instanceof LinearLayout) {
                            int tag = (Integer) v.getTag();
                            if (tag == mColors.length) {
                                if (colorView.getBorderDrawale() != null) {
                                    mIsDefaultColorSelect = false;
                                    mColor = colorView.getFillColor();
                                    if (mPropertyChangeListener != null) {
                                        mPropertyChangeListener.onValueChanged(PropertyBar.PROPERTY_SELF_COLOR, mColor);
                                    }
                                }

                                if (!mIsCustomColorPage) {
                                    int _contentWidth = mPropertyBar.mTabContentLl.getMeasuredWidth();
                                    mIsCustomColorPage = true;
                                    mPropertyBar.removeContentViews();
                                    mPropertyBar.addContentView(getColorPicker());
                                    mCustomColorsView.measure(0, 0);
                                    int height = mCustomColorsView.getMeasuredHeight();
                                    ViewGroup.LayoutParams layoutParams = mPropertyBar.mTabContentLl.getLayoutParams();
                                    layoutParams.height = mCustomColorsView.getMeasuredHeight();
                                    mPropertyBar.mTabContentLl.setLayoutParams(layoutParams);
                                    mPropertyBar.show(mPropertyBar.mAnchor,
                                            mPropertyBar.mRectF,
                                            _contentWidth,
                                            height,
                                            mPropertyBar.mArrowPosition);
                                }
                            } else {
                                mIsDefaultColorSelect = true;
                                mColor = mColors[tag];
                                if (mPropertyChangeListener != null) {
                                    mPropertyChangeListener.onValueChanged(PropertyBar.PROPERTY_COLOR, mColor);
                                }
                            }

                            for (int j = 0; j < colorsLength; j++) {
                                if (j == tag) {
                                    v.setBackgroundResource(R.drawable.common_border_radius_3_rectangle);
                                    v.getBackground().setColorFilter(new PorterDuffColorFilter(ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                                } else {
                                    LinearLayout colorRow = (LinearLayout) ((LinearLayout) v).getParent();
                                    LinearLayout otherColor = (LinearLayout) colorRow.getChildAt(j);
                                    otherColor.setBackgroundColor(Color.TRANSPARENT);
                                }
                            }
                        }
                    }
                });
            } else {
                linearLayout.setEnabled(false);
            }
        }
    }

    private View getColorPicker() {
        if (mCustomColorsView == null) {
            mCustomColorsView = View.inflate(mContext, R.layout.pb_custom_color_view, null);
            LinearLayout backView = mCustomColorsView.findViewById(R.id.pb_ll_back_view);
            LinearLayout.LayoutParams backParams = (LinearLayout.LayoutParams) backView.getLayoutParams();
            if (AppDisplay.isPad())
                backParams.height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_pad_height);
            else
                backParams.height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
            backView.setLayoutParams(backParams);
            backView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    mIsCustomColorPage = false;
                    mPropertyBar.reset(mPropertyBar.mSupportProperty, false);
                    mPropertyBar.update(mPropertyBar.mAnchor, mPropertyBar.mRectF);
                }
            });
            TextView titleView = mCustomColorsView.findViewById(R.id.pb_title_text_view);
            titleView.setText(AppResource.getString(mContext, R.string.pb_color_picker_title));

            ColorPicker colorPicker = mCustomColorsView.findViewById(R.id.pb_color_picker_view);
            colorPicker.setEditable(canEdit);
            colorPicker.setOnColorChangedListener(new ColorPicker.OnColorChangedListener() {
                @Override
                public void onColorChanged(int color) {
                    if (mIsDefaultColorSelect) {
                        for (int i = 0; i < mColors.length; i++) {
                            LinearLayout colorParent = (LinearLayout) mCustomPBLlColors.getChildAt(i);
                            colorParent.setBackgroundColor(Color.TRANSPARENT);
                        }
                    }
                    mColor = color;
                    mIsDefaultColorSelect = false;

                    LinearLayout colorParent = (LinearLayout) mCustomPBLlColors.getChildAt(mCustomPBLlColors.getChildCount() - 1);
                    UIFillView colorView = (UIFillView) colorParent.getChildAt(0);
                    if (colorView.getBorderDrawale() == null) {
                        colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_fill_color_bg));
                        colorView.setBorderDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_border_color_bg));
                        colorView.setBorderWidth(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_margin_6dp));
                    }
                    colorView.setFillColorFilter(mColor);
                    colorParent.setBackgroundResource(R.drawable.common_border_radius_3_rectangle);
                    colorParent.getBackground().setColorFilter(new PorterDuffColorFilter(ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                    if (mPropertyChangeListener != null) {
                        mPropertyChangeListener.onValueChanged(PropertyBar.PROPERTY_SELF_COLOR, color);
                    }
                }
            });
            LinearLayout.LayoutParams colorParams = (LinearLayout.LayoutParams) colorPicker.getLayoutParams();
            int height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_color_picker_height);
            int width;
            if (AppDisplay.isPad())
                width = mCurrentWidth - AppDisplay.dp2px(16.0f + 4.0f) * 2;
            else
                width = mCurrentWidth - AppDisplay.dp2px(16.0f) * 2;
            colorParams.width = width;
            colorParams.height = height;
            colorPicker.setLayoutParams(colorParams);
            colorPicker.setWidth(width);
            colorPicker.setHeight(height);
            colorPicker.setColor(mColor);

            mCustomPBLlColors = mCustomColorsView.findViewById(R.id.pb_custom_colors);
            initColors(mCustomPBLlColors);
        }

        for (int i = 0; i < mCustomPBLlColors.getChildCount(); i++) {
            LinearLayout colorParent = (LinearLayout) mCustomPBLlColors.getChildAt(i);

            if (i < mColors.length) {
                colorParent.setBackgroundColor(Color.TRANSPARENT);
            } else {
                colorParent.setBackgroundResource(R.drawable.common_border_radius_3_rectangle);
                colorParent.getBackground().setColorFilter(new PorterDuffColorFilter(ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                UIFillView colorView = (UIFillView) colorParent.getChildAt(0);
                if (mIsDefaultColorSelect) {
                    colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_none_fill_color_bg));
                    colorView.setBorderWidth(0);
                    colorView.setBorderDrawale(null);
                    colorView.setFillColorFilter(AppResource.getColor(mContext, R.color.ux_color_translucent));
                } else {
                    colorView.setFillDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_fill_color_bg));
                    colorView.setBorderDrawale(AppResource.getDrawable(getContext(), R.drawable.thumbnail_custom_border_color_bg));
                    colorView.setBorderWidth(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_margin_6dp));
                    colorView.setFillColorFilter(mColor);
                }
            }
        }
        return mCustomColorsView;
    }

    public void setColor(int color) {
        mColor = color;
    }

    public void setEditable(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setPropertyChangeListener(PropertyBar.PropertyChangeListener listener) {
        this.mPropertyChangeListener = listener;
    }

    public void reset() {
        removeAllViews();
        init();
    }

    public void setTitle(String title) {
        mPBColorTitle.setText(title);
    }

}
