/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar.imp;


import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;

class ShapeGridListAdaper extends SuperAdapter<ShapeGridListAdaper.GridItemInfo> {

    private OnGridItemClickListener itemClickListener;
    private List<GridItemInfo> itemInfos;

    public ShapeGridListAdaper(Context context) {
        super(context);
        itemInfos = new ArrayList<>();
    }

    List<GridItemInfo> getGridItemInfos(){
        return itemInfos;
    }

    void setItemInfos(List<GridItemInfo> infos) {
        itemInfos = infos;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public GridItemInfo getDataItem(int position) {
        return itemInfos.get(position);
    }

    @NonNull
    @Override
    public GridViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new GridViewHolder(LayoutInflater.from(getContext())
                .inflate(R.layout.pb_grid_view_layout, parent, false));
    }

    @Override
    public int getItemCount() {
        return itemInfos.size();
    }

    class GridViewHolder extends SuperViewHolder {

        private ImageView iconView;
        private LinearLayout iconSelecedView;

        public GridViewHolder(View itemView) {
            super(itemView);
            iconView = itemView.findViewById(R.id.pb_grid_item_icon);
            iconSelecedView = itemView.findViewById(R.id.pb_grid_item_ll);
        }

        @Override
        public void bind(BaseBean data, int position) {
            GridItemInfo itemInfo = (GridItemInfo) data;
            iconView.setImageResource(itemInfo.iconId);
            int color;
            if (itemInfo.isChecked)
                color = ThemeConfig.getInstance(getContext()).getPrimaryColor();
            else
                color = AppResource.getColor(getContext(), R.color.ux_color_translucent);
            iconSelecedView.setSelected(itemInfo.isChecked);
            iconSelecedView.getBackground().setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
            iconSelecedView.setOnClickListener(this);
        }

        @Override
        public void onClick(View v) {
            int position = getAdapterPosition();
            if (position == -1) return;

            int id = v.getId();
            if (id == R.id.pb_grid_item_ll) {
                for (GridItemInfo itemInfo : itemInfos) {
                    itemInfo.isChecked = false;
                }

                GridItemInfo itemInfo = itemInfos.get(position);
                itemInfo.isChecked = true;
                notifyUpdateData();
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, itemInfos.get(position));
                }
            }
        }
    }

    static class GridItemInfo extends BaseBean {
        int type;
        int iconId;
        boolean isChecked;
    }

    void setGridItemClickListener(OnGridItemClickListener gridItemClickListener) {
        itemClickListener = gridItemClickListener;
    }

    interface OnGridItemClickListener {
        void onItemClick(int position, GridItemInfo itemInfo);
    }

}
