/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;


import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.controls.toolbar.impl.UIColorItem;

public interface IToolSupply {
    UIColorItem createToolItem(@ToolConstants.ToolType int toolType, boolean onlyImage);

    ToolProperty createProperty(@ToolConstants.ToolType int toolType, @ToolConstants.Tool_Property_Type int properType);

    void onClick(ToolItemBean itemBean);

    void resetPropertyBar(ToolItemBean itemBean, PropertyBar.PropertyChangeListener propertyChangeListener);

    PropertyBar getPropertyBar();


    void setPropertyBar(ToolProperty property);
}
