/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

public class ToolConstants {
    //edit
    public static final int Text = 0;
    public static final int Image = 1;
    public static final int Audio = 2;
    public static final int Video = 3;
    public static final int Link = 4;

    //common
    public static final int Note = 100;
    public static final int Attachments = 101;
    public static final int Stamp = 102;
    public static final int Typewriter = 103;
    public static final int Callout = 104;
    public static final int Textbox = 105;
    public static final int Highlight = 106;
    public static final int Underline = 107;
    public static final int Squiggly = 108;
    public static final int Strikeout = 109;
    public static final int Replace_Text = 110;
    public static final int Insert_Text = 111;
    public static final int Area_Highlight = 112;
    public static final int Measure = 113;
    public static final int Image_Annotation = 114;

    //drawing
    public static final int Pencil = 200;
    public static final int Highlighter = 201;
    public static final int Eraser = 202;
    public static final int Rectangle = 203;
    public static final int Oval = 204;
    public static final int Line = 205;
    public static final int Arrow = 206;
    public static final int PolyLine = 207;
    public static final int Polygon = 208;
    public static final int Cloud = 209;

    //Form
    public static final int TextField = 300;
    public static final int CheckBox = 301;
    public static final int RadioButton = 302;
    public static final int ComboBox = 303;
    public static final int ListBox = 304;
    public static final int SignatureField = 305;
    public static final int ImageField = 306;

    //fillsign
    public static final int FillSignTypeText = 400;
    public static final int FillSignTypeComboText = 401;
    public static final int FillSignTypeProFile = 402;
    public static final int FillSignTypeCheckMark = 403;
    public static final int FillSignTypeCrossMark = 404;
    public static final int FillSignTypeDot = 405;
    public static final int FillSignTypeLine = 406;
    public static final int FillSignTypeRectangle = 407;

    //digital signature
    public static final int DigitalSignature = 500;

    //Protect
    public static final int ProtectTypeRedaction = 600;
    public static final int ProtectTypeStandard = 601;
    public static final int ProtectTypeStandRemove = 602;
    public static final int ProtectTypeTrustCert = 603;
    public static final int ProtectTypeCert = 604;
    public static final int ProtectTypeCertRemove = 605;
    public static final int ProtectTypeRMS = 606;
    public static final int ProtectTypeAIP = 607;

    //Foxit eSign
    public static final int CreateSignature = 700;
    public static final int ManageSignatures = 701;
    public static final int ApplyAllSignatures = 702;
    public static final int RequestSignature = 703;
    public static final int DocumentStaus = 704;
    public static final int SwitchAccount = 705;

    //View
    public static final int TypeSinglePage = 800;
    public static final int TypeDay = 801;
    public static final int TypePageColor = 802;
    public static final int TypeFitPage = 803;
    public static final int TypeFitWidth = 804;
    public static final int TypeReflow = 805;
    public static final int TypeCrop = 806;
    public static final int TypeTts = 807;
    public static final int TypeAutoFlip = 808;
    public static final int TypeRotateView = 809;
    public static final int TypePanZoom = 810;
    public static final int TypeNight = 811;

    @IntDef({
            //edit
            Text,
            Image,
            Audio,
            Video,
            Link,

            //common
            Note,
            Attachments,
            Stamp,
            Typewriter,
            Textbox,
            Callout,
            Highlight,
            Underline,
            Squiggly,
            Strikeout,
            Replace_Text,
            Insert_Text,
            Area_Highlight,
            Measure,
            Image_Annotation,

            //drawing
            Pencil,
            Highlighter,
            Eraser,
            Rectangle,
            Oval,
            Line,
            Arrow,
            PolyLine,
            Polygon,
            Cloud,

            //Form
            TextField,
            CheckBox,
            RadioButton,
            ComboBox,
            ListBox,
            SignatureField,
            ImageField,

            //fillsign
            FillSignTypeText,
            FillSignTypeComboText,
            FillSignTypeProFile,
            FillSignTypeCheckMark,
            FillSignTypeCrossMark,
            FillSignTypeDot,
            FillSignTypeLine,
            FillSignTypeRectangle,

            //digital signature
            DigitalSignature,

            //Protect
            ProtectTypeRedaction,
            ProtectTypeStandard,
            ProtectTypeStandRemove,
            ProtectTypeTrustCert,
            ProtectTypeCert,
            ProtectTypeCertRemove,
            ProtectTypeRMS,
            ProtectTypeAIP,

            //Foxit eSign
            CreateSignature,
            ManageSignatures,
            ApplyAllSignatures,
            RequestSignature,
            DocumentStaus,
            SwitchAccount,

            //View
            TypeSinglePage,
            TypeDay,
            TypePageColor,
            TypeFitPage,
            TypeFitWidth,
            TypeReflow,
            TypeCrop,
            TypeTts,
            TypeAutoFlip,
            TypeRotateView,
            TypePanZoom
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface ToolType {
    }

    public static final int Divider = 0;
    public static final int Multi_Select = 1;
    public static final int Property = 2;
    public static final int Undo = 3;
    public static final int Redo = 4;
    public static final int MoreUndo = 5;
    public static final int MoreRedo = 6;
    public static final int Add = 7;
    public static final int Drag = 8;
    public static final int sort = 9;


    @IntDef({
            Divider,
            Multi_Select,
            Property,
            Undo,
            Redo,
            MoreUndo,
            MoreRedo,
            Add,
            Drag,
            sort
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface OperType {
    }

    public static final int DEFAULT_PROP = 0;
    public static final int ADD_TOOLS_PROP = 1;

    @IntDef({
            DEFAULT_PROP,
            ADD_TOOLS_PROP,
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface Tool_Property_Type {
    }

}
