/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;


import com.foxit.uiextensions.modules.panel.bean.BaseBean;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

public class ToolItemBean extends BaseBean {
    public static final int DEFAULT_STYLE = 0;
    public static final int CUSTOM_STYLE = 1;

    @IntDef({
            DEFAULT_STYLE,
            CUSTOM_STYLE
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface ToolItemStyle {
    }

    public @ToolItemStyle int itemStyle;

    public int type;
    public String name;
    public ToolProperty property;
    public IBaseItem toolItem;
}
